/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.config.migrator.transformer.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.sakurawald.fuji.core.auxiliary.ExceptionUtil;
import io.github.sakurawald.fuji.core.auxiliary.IOUtil;
import io.github.sakurawald.fuji.core.auxiliary.JsonUtil;
import io.github.sakurawald.fuji.core.config.migrator.transformer.abst.ConfigurationTransformer;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;
import lombok.Generated;

public class InflateDirectoryIntoSingleFileTransformer
extends ConfigurationTransformer {
    private final Path inputDirectoryPath;
    private final Path outputFilePath;
    private final Function<JsonObject, JsonArray> outputArrayProvider;
    private final BiFunction<String, JsonObject, JsonObject> mapper;

    @Override
    protected boolean canApply() {
        if (!Files.exists(this.inputDirectoryPath, new LinkOption[0])) {
            return false;
        }
        return !Files.exists(this.outputFilePath, new LinkOption[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void apply() {
        Stream<Path> inputFiles = Files.list(this.inputDirectoryPath);
        try {
            JsonObject outputJson = new JsonObject();
            JsonArray outputArray = this.outputArrayProvider.apply(outputJson);
            inputFiles.toList().forEach(inputFilePath -> {
                String inputFileName = inputFilePath.getFileName().toString();
                JsonObject inputFileJson = JsonUtil.readJsonFile(inputFilePath).getAsJsonObject();
                JsonObject outputFileJson = this.mapper.apply(inputFileName, inputFileJson);
                outputArray.add((JsonElement)outputFileJson);
                try {
                    Files.delete(inputFilePath);
                }
                catch (IOException e) {
                    throw ExceptionUtil.makeReThrownException(e);
                }
            });
            JsonUtil.writeJsonObject(outputJson, this.outputFilePath);
            IOUtil.deleteDirectoryIfEmpty(this.inputDirectoryPath);
        }
        finally {
            if (Collections.singletonList(inputFiles).get(0) != null) {
                inputFiles.close();
            }
        }
    }

    @Generated
    public Path getInputDirectoryPath() {
        return this.inputDirectoryPath;
    }

    @Generated
    public Path getOutputFilePath() {
        return this.outputFilePath;
    }

    @Generated
    public Function<JsonObject, JsonArray> getOutputArrayProvider() {
        return this.outputArrayProvider;
    }

    @Generated
    public BiFunction<String, JsonObject, JsonObject> getMapper() {
        return this.mapper;
    }

    @Generated
    public String toString() {
        return "InflateDirectoryIntoSingleFileTransformer(inputDirectoryPath=" + String.valueOf(this.getInputDirectoryPath()) + ", outputFilePath=" + String.valueOf(this.getOutputFilePath()) + ", outputArrayProvider=" + String.valueOf(this.getOutputArrayProvider()) + ", mapper=" + String.valueOf(this.getMapper()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InflateDirectoryIntoSingleFileTransformer)) {
            return false;
        }
        InflateDirectoryIntoSingleFileTransformer other = (InflateDirectoryIntoSingleFileTransformer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Path this$inputDirectoryPath = this.getInputDirectoryPath();
        Path other$inputDirectoryPath = other.getInputDirectoryPath();
        if (this$inputDirectoryPath == null ? other$inputDirectoryPath != null : !((Object)this$inputDirectoryPath).equals(other$inputDirectoryPath)) {
            return false;
        }
        Path this$outputFilePath = this.getOutputFilePath();
        Path other$outputFilePath = other.getOutputFilePath();
        if (this$outputFilePath == null ? other$outputFilePath != null : !((Object)this$outputFilePath).equals(other$outputFilePath)) {
            return false;
        }
        Function<JsonObject, JsonArray> this$outputArrayProvider = this.getOutputArrayProvider();
        Function<JsonObject, JsonArray> other$outputArrayProvider = other.getOutputArrayProvider();
        if (this$outputArrayProvider == null ? other$outputArrayProvider != null : !this$outputArrayProvider.equals(other$outputArrayProvider)) {
            return false;
        }
        BiFunction<String, JsonObject, JsonObject> this$mapper = this.getMapper();
        BiFunction<String, JsonObject, JsonObject> other$mapper = other.getMapper();
        return !(this$mapper == null ? other$mapper != null : !this$mapper.equals(other$mapper));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof InflateDirectoryIntoSingleFileTransformer;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Path $inputDirectoryPath = this.getInputDirectoryPath();
        result = result * 59 + ($inputDirectoryPath == null ? 43 : ((Object)$inputDirectoryPath).hashCode());
        Path $outputFilePath = this.getOutputFilePath();
        result = result * 59 + ($outputFilePath == null ? 43 : ((Object)$outputFilePath).hashCode());
        Function<JsonObject, JsonArray> $outputArrayProvider = this.getOutputArrayProvider();
        result = result * 59 + ($outputArrayProvider == null ? 43 : $outputArrayProvider.hashCode());
        BiFunction<String, JsonObject, JsonObject> $mapper = this.getMapper();
        result = result * 59 + ($mapper == null ? 43 : $mapper.hashCode());
        return result;
    }

    @Generated
    public InflateDirectoryIntoSingleFileTransformer(Path inputDirectoryPath, Path outputFilePath, Function<JsonObject, JsonArray> outputArrayProvider, BiFunction<String, JsonObject, JsonObject> mapper) {
        this.inputDirectoryPath = inputDirectoryPath;
        this.outputFilePath = outputFilePath;
        this.outputArrayProvider = outputArrayProvider;
        this.mapper = mapper;
    }
}

