/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.manager.impl.attachment;

import io.github.sakurawald.fuji.Fuji;
import io.github.sakurawald.fuji.core.manager.abst.BaseManager;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.Nullable;

public class AttachmentManager
extends BaseManager {
    public static final Path ATTACHMENT_STORAGE_PATH = Fuji.MOD_CONFIG_PATH.resolve("attachment");

    @Override
    public void onInitialize() {
    }

    private File makeFile(String subject, String uuid) throws IOException {
        Path path = ATTACHMENT_STORAGE_PATH.resolve(subject).resolve(uuid);
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        return path.toFile();
    }

    public boolean existsAttachment(String subject, @Nullable String uuid) {
        if (uuid == null) {
            return false;
        }
        return Files.exists(ATTACHMENT_STORAGE_PATH.resolve(subject).resolve(uuid), new LinkOption[0]);
    }

    public void setAttachment(String subject, String uuid, String data) throws IOException {
        File file = this.makeFile(subject, uuid);
        Files.writeString(file.toPath(), (CharSequence)data, new OpenOption[0]);
    }

    public String getAttachment(String subject, String uuid) throws IOException {
        File file = this.makeFile(subject, uuid);
        return FileUtils.readFileToString((File)file, (Charset)Charset.defaultCharset());
    }

    public boolean unsetAttachment(String subject, String uuid) throws IOException {
        File file = this.makeFile(subject, uuid);
        return file.delete();
    }

    public List<String> listSubjectId(String subject) {
        try {
            File[] array = ATTACHMENT_STORAGE_PATH.resolve(subject).toFile().listFiles();
            if (array == null) {
                return Collections.emptyList();
            }
            return Arrays.stream(array).filter(File::isFile).map(File::getName).collect(Collectors.toList());
        }
        catch (Exception ignored) {
            return List.of();
        }
    }

    public List<String> listSubjectName() {
        try {
            File[] array = ATTACHMENT_STORAGE_PATH.toFile().listFiles();
            if (array == null) {
                return Collections.emptyList();
            }
            return Arrays.stream(array).filter(File::isDirectory).map(File::getName).collect(Collectors.toList());
        }
        catch (Exception ignored) {
            return List.of();
        }
    }
}

