/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.manager.impl.cache.service;

import com.mojang.authlib.GameProfile;
import io.github.sakurawald.fuji.core.auxiliary.LogUtil;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.PlayerHelper;
import io.github.sakurawald.fuji.core.config.mapper.wrapper.GameProfileWrapper;
import io.github.sakurawald.fuji.core.manager.Managers;
import io.github.sakurawald.fuji.core.service.gameprofile_fetcher.MojangProfileFetcher;
import java.time.Duration;
import java.util.function.Supplier;
import net.minecraft.class_1657;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

public class GameProfileCacheService {
    private static final String GAME_PROFILE_CACHE_KEY = "game_profile";

    public static void setGameProfileCache(@NotNull class_3222 player) {
        String playerName = PlayerHelper.getPlayerName((class_1657)player);
        GameProfileWrapper cachedGameProfile = GameProfileCacheService.getCachedGameProfile(player);
        LogUtil.debug("Set game profile cache for player {}. (cache = {})", playerName, cachedGameProfile);
    }

    @NotNull
    public static GameProfileWrapper getCachedGameProfile(@NotNull String onlinePlayerName) {
        return GameProfileCacheService.getCachedGameProfile(onlinePlayerName, Duration.ofDays(7L), () -> GameProfileCacheService.supplyOnlineGameProfile(onlinePlayerName));
    }

    @NotNull
    public static GameProfileWrapper getCachedGameProfile(@NotNull class_3222 player) {
        String playerName = PlayerHelper.getPlayerName((class_1657)player);
        return GameProfileCacheService.getCachedGameProfile(playerName, Duration.ofMillis(0L), () -> GameProfileCacheService.supplyOfflineGameProfile(player));
    }

    @NotNull
    private static GameProfileWrapper getCachedGameProfile(@NotNull String onlinePlayerName, @NotNull Duration expirationDuration, @NotNull Supplier<GameProfileWrapper> supplier) {
        return Managers.getCacheManager().getCachedValueOrCompute(GAME_PROFILE_CACHE_KEY, onlinePlayerName, GameProfileWrapper.class, expirationDuration, supplier);
    }

    @NotNull
    private static GameProfileWrapper supplyOfflineGameProfile(@NotNull class_3222 serverPlayerEntity) {
        return GameProfileWrapper.fromVanillaType(serverPlayerEntity.method_7334());
    }

    @NotNull
    private static GameProfileWrapper supplyOnlineGameProfile(@NotNull String onlinePlayerName) {
        return MojangProfileFetcher.fetchOnlinePlayerUUID(onlinePlayerName).map(uuid -> {
            GameProfile gameProfile = new GameProfile(uuid, onlinePlayerName);
            return MojangProfileFetcher.fetchOnlineGameProfile(onlinePlayerName).map(GameProfileWrapper::fromVanillaType).orElseGet(() -> new GameProfileWrapper(gameProfile.getId(), gameProfile.getName(), gameProfile.getProperties()));
        }).orElseGet(() -> new GameProfileWrapper(null, onlinePlayerName));
    }
}

