/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.manager.impl.cache.structure;

import java.time.Duration;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public class Cache<T> {
    private T value;
    private long updatedTimestamp;

    public static <T> Cache<T> of(@NotNull T value) {
        Cache<T> result = new Cache<T>();
        result.value = value;
        result.updatedTimestamp = System.currentTimeMillis();
        return result;
    }

    public boolean isWithinExpirationDuration(@NotNull Duration expirationDuration) {
        long currentTime = System.currentTimeMillis();
        return this.getUpdatedTimestamp() + expirationDuration.toMillis() < currentTime;
    }

    @Generated
    public T getValue() {
        return this.value;
    }

    @Generated
    public long getUpdatedTimestamp() {
        return this.updatedTimestamp;
    }

    @Generated
    public Cache<T> setValue(T value) {
        this.value = value;
        return this;
    }

    @Generated
    public Cache<T> setUpdatedTimestamp(long updatedTimestamp) {
        this.updatedTimestamp = updatedTimestamp;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Cache)) {
            return false;
        }
        Cache other = (Cache)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getUpdatedTimestamp() != other.getUpdatedTimestamp()) {
            return false;
        }
        T this$value = this.getValue();
        T other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Cache;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $updatedTimestamp = this.getUpdatedTimestamp();
        result = result * 59 + (int)($updatedTimestamp >>> 32 ^ $updatedTimestamp);
        T $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Cache(value=" + String.valueOf(this.getValue()) + ", updatedTimestamp=" + this.getUpdatedTimestamp() + ")";
    }

    @Generated
    private Cache() {
    }
}

