/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.manager.impl.scheduler;

import io.github.sakurawald.fuji.core.annotation.Unused;
import io.github.sakurawald.fuji.core.auxiliary.ExceptionUtil;
import io.github.sakurawald.fuji.core.auxiliary.LogUtil;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.ServerHelper;
import io.github.sakurawald.fuji.core.config.Configs;
import io.github.sakurawald.fuji.core.document.annotation.TestCase;
import io.github.sakurawald.fuji.core.event.annotation.EventConsumer;
import io.github.sakurawald.fuji.core.event.message.server.lifecycle.ServerStartedEvent;
import io.github.sakurawald.fuji.core.event.message.server.lifecycle.ServerStoppingEvent;
import io.github.sakurawald.fuji.core.job.abst.BaseJob;
import io.github.sakurawald.fuji.core.manager.abst.BaseManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.config.Configurator;
import org.jetbrains.annotations.NotNull;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.impl.matchers.GroupMatcher;

@TestCase(action="Issue `/stop` in the production environment.", targets={"The program should be terminated."})
public class ScheduleManager
extends BaseManager {
    public static final String CRON_EVERY_SECOND = "* * * ? * *";
    public static final String CRON_EVERY_FIVE_SECONDS = "0/5 * * ? * * *";
    public static final String CRON_EVERY_TEN_SECONDS = "0/10 * * ? * * *";
    public static final String CRON_EVERY_MINUTE = "0 * * ? * * *";
    public static final String CRON_EVERY_THREE_MINUTES = "0 */3 * ? * *";
    public static final String CRON_EVERY_FIVE_MINUTES = "0 */5 * ? * *";
    private static final Set<BaseJob> RESCHEDULABLE_JOBS = new HashSet<BaseJob>();
    private static Scheduler scheduler;

    public void scheduleJob(BaseJob baseJob) {
        JobDetail jobDetail = baseJob.getJobDetail();
        Trigger trigger = baseJob.makeTrigger();
        try {
            LogUtil.debug("Schedule job: jobDetail = {}, trigger = {}", jobDetail, trigger);
            if (baseJob.isRescheduleAble()) {
                RESCHEDULABLE_JOBS.add(baseJob);
            }
            scheduler.scheduleJob(jobDetail, trigger);
        }
        catch (SchedulerException e) {
            LogUtil.error("Failed to schedule job: jobDetail = {}, trigger = {}", new Object[]{jobDetail, trigger, e});
        }
    }

    public void rescheduleJob(BaseJob baseJob) {
        TriggerKey triggerKey = baseJob.getTriggerKey();
        Trigger newTrigger = baseJob.makeTrigger();
        try {
            LogUtil.debug("Re-schedule job: triggerKey = {}, newTrigger = {}", triggerKey, newTrigger);
            scheduler.rescheduleJob(triggerKey, newTrigger);
        }
        catch (SchedulerException e) {
            LogUtil.error("Failed to reschedule job: triggerKey = {}, newTrigger = {}", new Object[]{triggerKey, newTrigger, e});
        }
    }

    public void rescheduleJobs() {
        RESCHEDULABLE_JOBS.forEach(this::rescheduleJob);
    }

    public void deleteJobs(Class<?> clazz) {
        ArrayList<JobKey> jobKeys = new ArrayList<JobKey>(this.getJobKeys(clazz.getName()));
        this.deleteJobs(jobKeys);
    }

    private void deleteJobs(List<JobKey> jobKeys) {
        try {
            LogUtil.debug("Delete job keys: {}", jobKeys);
            scheduler.deleteJobs(jobKeys);
        }
        catch (SchedulerException e) {
            LogUtil.error("Failed to delete jobs: jobKeys = {}", new Object[]{jobKeys, e});
        }
    }

    private Set<JobKey> getJobKeys(@NotNull String jobGroup) {
        GroupMatcher groupMatcher = GroupMatcher.groupEquals((String)jobGroup);
        try {
            return scheduler.getJobKeys(groupMatcher);
        }
        catch (SchedulerException e) {
            LogUtil.error("Failed to get job keys: jobGroup = {}", new Object[]{jobGroup, e});
            return Collections.emptySet();
        }
    }

    public void triggerJobs(@NotNull String jobGroup) {
        this.getJobKeys(jobGroup).forEach(jobKey -> {
            try {
                scheduler.triggerJob(jobKey);
            }
            catch (SchedulerException e) {
                LogUtil.error("Failed to trigger jobs: jobGroup = {}", new Object[]{jobGroup, e});
            }
        });
    }

    private static void resetScheduler() {
        try {
            StdSchedulerFactory stdSchedulerFactory = new StdSchedulerFactory();
            scheduler = stdSchedulerFactory.getScheduler();
        }
        catch (SchedulerException e) {
            throw ExceptionUtil.makeReThrownException((Exception)((Object)e));
        }
    }

    @EventConsumer
    private static void startScheduler(@Unused ServerStartedEvent event) {
        ScheduleManager.resetScheduler();
        try {
            scheduler.start();
        }
        catch (SchedulerException e) {
            LogUtil.error("Failed to start the scheduler.", new Object[]{e});
        }
    }

    @EventConsumer
    private static void shutdownScheduler(@Unused ServerStoppingEvent event) {
        try {
            scheduler.shutdown(false);
            if (ServerHelper.isClientSideIntegratedServer()) {
                ScheduleManager.resetScheduler();
            }
        }
        catch (SchedulerException e) {
            LogUtil.error("Failed to shutdown the scheduler", new Object[]{e});
        }
    }

    @Override
    public void onInitialize() {
    }

    @Generated
    public static Scheduler getScheduler() {
        return scheduler;
    }

    static {
        Level level = Level.getLevel((String)Configs.MAIN_CONTROL_CONFIG.model().core.scheduler.logger_level);
        Configurator.setAllLevels((String)"org.quartz", (Level)level);
        ScheduleManager.resetScheduler();
    }
}

