/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.service.async_chunk_loader;

import io.github.sakurawald.fuji.core.manager.impl.task.structure.GameTask;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import lombok.Generated;
import net.minecraft.class_1923;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_3218;
import org.jetbrains.annotations.NotNull;

public class AsyncChunkLoadTask
extends GameTask {
    private final CompletableFuture<Void> chunkAsyncLoadingFuture = new CompletableFuture();
    private final AtomicBoolean consumed = new AtomicBoolean(false);

    public AsyncChunkLoadTask(@NotNull class_3218 serverWorld, @NotNull class_1923 chunkPos, int timeoutTicks, @NotNull Consumer<class_2791> chunkConsumer, @NotNull Runnable onFailed) {
        super(timeoutTicks);
        this.setOnTick(() -> {
            if (this.consumed.get() || this.chunkAsyncLoadingFuture.isDone()) {
                return;
            }
            CompletableFuture<Optional<class_2791>> chunkFuture = AsyncChunkLoadTask.getChunkFuture(serverWorld, chunkPos);
            CompletionStage unused = ((CompletableFuture)chunkFuture.thenAccept(it -> it.ifPresent(chunk -> {
                if (this.consumed.compareAndSet(false, true)) {
                    this.setCompleted(true);
                    chunkConsumer.accept((class_2791)chunk);
                    this.chunkAsyncLoadingFuture.complete(null);
                }
            }))).exceptionally(ex -> {
                this.chunkAsyncLoadingFuture.completeExceptionally((Throwable)ex);
                return null;
            });
        });
        this.setOnEnd(() -> {
            if (!this.consumed.get()) {
                onFailed.run();
            }
            this.chunkAsyncLoadingFuture.complete(null);
        });
    }

    private static CompletableFuture<Optional<class_2791>> getChunkFuture(@NotNull class_3218 serverWorld, @NotNull class_1923 chunkPos) {
        CompletableFuture future = serverWorld.method_14178().method_14134(chunkPos.field_9181, chunkPos.field_9180, class_2806.field_12803, true);
        return future.thenApply(it -> it.left());
    }

    @Generated
    public CompletableFuture<Void> getChunkAsyncLoadingFuture() {
        return this.chunkAsyncLoadingFuture;
    }
}

