/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.service.display.gui;

import com.google.errorprone.annotations.Keep;
import eu.pb4.sgui.api.gui.SimpleGui;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.GuiHelper;
import io.github.sakurawald.fuji.core.service.display.gui.BaseDisplayGuiFactory;
import java.util.stream.Stream;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShulkerBoxDisplayGuiFactory
extends BaseDisplayGuiFactory {
    @Keep
    private static final int SHULKER_BOX_MAX_CAPACITY = 27;
    @NotNull
    private final class_1799 shulkerBoxStack;
    @Nullable
    private final SimpleGui parentGui;

    public ShulkerBoxDisplayGuiFactory(class_2561 title, @NotNull class_1799 shulkerBoxStack, @Nullable SimpleGui parentGui) {
        super(title);
        this.shulkerBoxStack = shulkerBoxStack;
        this.parentGui = parentGui;
    }

    public ShulkerBoxDisplayGuiFactory(class_3222 sourcePlayer, @NotNull class_1799 shulkerBoxStack, @Nullable SimpleGui parentGui) {
        super(sourcePlayer);
        this.shulkerBoxStack = shulkerBoxStack;
        this.parentGui = parentGui;
    }

    @NotNull
    private static Stream<class_1799> extractItemsFromShulkerBox(class_1799 stack) {
        class_2487 blockEntityData = class_1747.method_38072((class_1799)stack);
        if (blockEntityData != null) {
            class_2499 items = (class_2499)blockEntityData.method_10580("Items");
            if (items == null) {
                return Stream.empty();
            }
            class_2371 temp = class_2371.method_10213((int)27, (Object)class_1799.field_8037);
            items.forEach(item -> {
                class_2487 itemNbtCompound = (class_2487)item;
                int slotIndex = itemNbtCompound.method_10550("Slot");
                class_1799 itemStack = class_1799.method_7915((class_2487)itemNbtCompound);
                temp.set(slotIndex, (Object)itemStack);
            });
            return temp.stream();
        }
        return Stream.empty();
    }

    @Override
    @NotNull
    public SimpleGui build(class_3222 viewingPlayer) {
        SimpleGui gui = new SimpleGui(class_3917.field_18666, viewingPlayer, false);
        gui.setTitle(this.title);
        for (int i = 0; i < 9; ++i) {
            gui.setSlot(i, GuiHelper.Button.makeSlotPlaceholderButton().getItemStack());
        }
        gui.setSlot(4, this.shulkerBoxStack);
        if (this.parentGui != null) {
            gui.setSlot(8, GuiHelper.Button.makeBackButton(viewingPlayer).setCallback(() -> ((SimpleGui)this.parentGui).open()));
        }
        Stream<class_1799> containerStream = ShulkerBoxDisplayGuiFactory.extractItemsFromShulkerBox(this.shulkerBoxStack);
        Object counter = new Object(){
            private int offset = 0;
        };
        containerStream.forEach(arg_0 -> ShulkerBoxDisplayGuiFactory.lambda$build$1(gui, counter, arg_0));
        return gui;
    }

    private static /* synthetic */ void lambda$build$1(SimpleGui gui, 1 counter, class_1799 item) {
        gui.setSlot(9 + counter.offset, item.method_7972());
        ++counter.offset;
    }
}

