/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.service.gameprofile_fetcher;

import com.google.gson.JsonParser;
import com.mojang.authlib.GameProfile;
import io.github.sakurawald.fuji.core.auxiliary.HttpUtil;
import io.github.sakurawald.fuji.core.auxiliary.LogUtil;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.AuthlibHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.PlayerHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.ServerHelper;
import io.github.sakurawald.fuji.core.service.gameprofile_fetcher.MojangSkinProvider;
import java.io.IOException;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Pattern;
import net.minecraft.class_3312;
import org.jetbrains.annotations.NotNull;

public class MojangProfileFetcher {
    private static final String API_SERVER = "https://api.mojang.com/users/profiles/minecraft/";
    private static final Pattern UUID_CONVERTER_PATTERN = Pattern.compile("(\\p{XDigit}{8})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}+)");

    public static Optional<GameProfile> fetchOnlineGameProfile(@NotNull String playerName) {
        return MojangProfileFetcher.fetchOnlinePlayerUUID(playerName).map(uuid -> new GameProfile(uuid, playerName)).map(gameProfile -> {
            MojangSkinProvider.fetchSkin(playerName).ifPresent(property -> AuthlibHelper.modifyGameProfile(gameProfile, property));
            return gameProfile;
        });
    }

    public static Optional<UUID> fetchOnlinePlayerUUID(@NotNull String playerName) {
        class_3312 userCache = ServerHelper.getServer().method_3793();
        if (userCache == null) {
            return MojangProfileFetcher.fetchOnlinePlayerUUID$Fallback(playerName);
        }
        try {
            return PlayerHelper.Cache.getOfflineGameProfileByName(playerName).map(GameProfile::getId).or(() -> MojangProfileFetcher.fetchOnlinePlayerUUID$Fallback(playerName));
        }
        catch (Exception e) {
            return MojangProfileFetcher.fetchOnlinePlayerUUID$Fallback(playerName);
        }
    }

    private static Optional<UUID> fetchOnlinePlayerUUID$Fallback(@NotNull String playerName) {
        String rawUUID;
        try {
            String json = HttpUtil.sendGetRequest(API_SERVER + playerName);
            rawUUID = JsonParser.parseString((String)json).getAsJsonObject().get("id").getAsString();
        }
        catch (IOException e) {
            LogUtil.debug("Failed to fetch online uuid from mojang server for {}", playerName);
            return Optional.empty();
        }
        UUID value = UUID.fromString(UUID_CONVERTER_PATTERN.matcher(rawUUID).replaceFirst("$1-$2-$3-$4-$5"));
        return Optional.of(value);
    }
}

