/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.service.random_teleport;

import com.google.common.base.Stopwatch;
import io.github.sakurawald.fuji.core.auxiliary.AsyncUtil;
import io.github.sakurawald.fuji.core.auxiliary.LogUtil;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.PlayerHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.RegistryHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.ServerHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.WorldHelper;
import io.github.sakurawald.fuji.core.document.annotation.Cite;
import io.github.sakurawald.fuji.core.service.random_teleport.searcher.PositionSearcher;
import io.github.sakurawald.fuji.core.service.random_teleport.structure.PositionSearchContext;
import io.github.sakurawald.fuji.core.service.random_teleport.structure.RandomTeleportSettings;
import io.github.sakurawald.fuji.core.structure.GlobalPos;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Cite(value={"https://github.com/John-Paul-R/Essential-Commands"})
public class RandomTeleporter {
    public static void request(@NotNull class_3222 player, @NotNull RandomTeleportSettings settings, @Nullable Consumer<GlobalPos> onCompleteHook) {
        AsyncUtil.runAsyncAndHandleExceptions(() -> {
            String playerName = PlayerHelper.getPlayerName((class_1657)player);
            Stopwatch timer = Stopwatch.createStarted();
            LogUtil.info("Request rtp: {}", playerName);
            TextHelper.sendTextByKey(player, "rtp.progress.started", new Object[0]);
            Optional<class_3218> world = WorldHelper.getWorld(settings.getDimension());
            if (world.isEmpty()) {
                LogUtil.warn("Abort rtp for {} (Target dimension not found in server)", player);
                TextHelper.sendTextByKey(player, "world.dimension.not_found", new Object[0]);
                return;
            }
            class_3218 $world = world.get();
            PositionSearchContext context = PositionSearchContext.of(player, settings);
            do {
                context.incrementAttempts();
                TextHelper.sendTextByKey(player, "rtp.progress.searching", context.getAttempts(), context.getMaxAttempts());
                PositionSearcher.search(context);
                if (!player.method_31481()) continue;
                LogUtil.info("Abort RTP: The player {} has been removed.", playerName);
                return;
            } while (context.getResult().isEmpty() && context.hasRemainingAttempts());
            Optional<class_2338> result = context.getResult();
            if (result.isEmpty()) {
                TextHelper.sendTextByKey(player, "rtp.progress.run_out_attempts", new Object[0]);
                return;
            }
            class_2338 $result = result.get();
            TextHelper.sendTextByKey(player, "rtp.progress.location_found", $result.method_10263(), $result.method_10264(), $result.method_10260());
            GlobalPos globalPos = new GlobalPos((class_1937)$world, (double)$result.method_10263() + 0.5, (double)$result.method_10264(), (double)$result.method_10260() + 0.5, 0.0f, 0.0f);
            TextHelper.sendTextByKey(player, "rtp.progress.teleporting", new Object[0]);
            ServerHelper.executeSync(() -> globalPos.teleport(player));
            if (onCompleteHook != null) {
                onCompleteHook.accept(globalPos);
            }
            Stopwatch cost = timer.stop();
            LogUtil.info("Response rtp: {} has been teleported to ({} {} {} {}) (cost = {})", playerName, RegistryHelper.getIdAsString((class_1937)$world), $result.method_10263(), $result.method_10264(), $result.method_10260(), cost);
        });
    }
}

