/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.service.random_teleport.structure;

import io.github.sakurawald.fuji.core.service.random_teleport.structure.RandomTeleportSettings;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

public class PositionSearchContext {
    @NotNull
    private class_3222 player;
    @NotNull
    private RandomTeleportSettings settings;
    @NotNull
    private List<class_1923> chunkPosQueue;
    @NotNull
    private List<class_2338> blockPosQueue;
    private int attempts = 0;
    @NotNull
    private Optional<class_2338> result;

    public boolean hasRemainingAttempts() {
        return this.getAttempts() < this.getMaxAttempts();
    }

    public void incrementAttempts() {
        ++this.attempts;
    }

    public int getMaxAttempts() {
        return this.settings.getMaxTryTimes();
    }

    @NotNull
    public static PositionSearchContext of(@NotNull class_3222 player, @NotNull RandomTeleportSettings settings) {
        PositionSearchContext positionSearchContext = new PositionSearchContext(player, settings, new ArrayList<class_1923>(), new ArrayList<class_2338>(), Optional.empty());
        return positionSearchContext;
    }

    @Generated
    public PositionSearchContext(@NotNull class_3222 player, @NotNull RandomTeleportSettings settings, @NotNull List<class_1923> chunkPosQueue, @NotNull List<class_2338> blockPosQueue, @NotNull Optional<class_2338> result) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (settings == null) {
            throw new NullPointerException("settings is marked non-null but is null");
        }
        if (chunkPosQueue == null) {
            throw new NullPointerException("chunkPosQueue is marked non-null but is null");
        }
        if (blockPosQueue == null) {
            throw new NullPointerException("blockPosQueue is marked non-null but is null");
        }
        if (result == null) {
            throw new NullPointerException("result is marked non-null but is null");
        }
        this.player = player;
        this.settings = settings;
        this.chunkPosQueue = chunkPosQueue;
        this.blockPosQueue = blockPosQueue;
        this.result = result;
    }

    @NotNull
    @Generated
    public class_3222 getPlayer() {
        return this.player;
    }

    @NotNull
    @Generated
    public RandomTeleportSettings getSettings() {
        return this.settings;
    }

    @NotNull
    @Generated
    public List<class_1923> getChunkPosQueue() {
        return this.chunkPosQueue;
    }

    @NotNull
    @Generated
    public List<class_2338> getBlockPosQueue() {
        return this.blockPosQueue;
    }

    @Generated
    public int getAttempts() {
        return this.attempts;
    }

    @NotNull
    @Generated
    public Optional<class_2338> getResult() {
        return this.result;
    }

    @Generated
    public PositionSearchContext setPlayer(@NotNull class_3222 player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.player = player;
        return this;
    }

    @Generated
    public PositionSearchContext setSettings(@NotNull RandomTeleportSettings settings) {
        if (settings == null) {
            throw new NullPointerException("settings is marked non-null but is null");
        }
        this.settings = settings;
        return this;
    }

    @Generated
    public PositionSearchContext setChunkPosQueue(@NotNull List<class_1923> chunkPosQueue) {
        if (chunkPosQueue == null) {
            throw new NullPointerException("chunkPosQueue is marked non-null but is null");
        }
        this.chunkPosQueue = chunkPosQueue;
        return this;
    }

    @Generated
    public PositionSearchContext setBlockPosQueue(@NotNull List<class_2338> blockPosQueue) {
        if (blockPosQueue == null) {
            throw new NullPointerException("blockPosQueue is marked non-null but is null");
        }
        this.blockPosQueue = blockPosQueue;
        return this;
    }

    @Generated
    public PositionSearchContext setAttempts(int attempts) {
        this.attempts = attempts;
        return this;
    }

    @Generated
    public PositionSearchContext setResult(@NotNull Optional<class_2338> result) {
        if (result == null) {
            throw new NullPointerException("result is marked non-null but is null");
        }
        this.result = result;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PositionSearchContext)) {
            return false;
        }
        PositionSearchContext other = (PositionSearchContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getAttempts() != other.getAttempts()) {
            return false;
        }
        class_3222 this$player = this.getPlayer();
        class_3222 other$player = other.getPlayer();
        if (this$player == null ? other$player != null : !this$player.equals(other$player)) {
            return false;
        }
        RandomTeleportSettings this$settings = this.getSettings();
        RandomTeleportSettings other$settings = other.getSettings();
        if (this$settings == null ? other$settings != null : !((Object)this$settings).equals(other$settings)) {
            return false;
        }
        List<class_1923> this$chunkPosQueue = this.getChunkPosQueue();
        List<class_1923> other$chunkPosQueue = other.getChunkPosQueue();
        if (this$chunkPosQueue == null ? other$chunkPosQueue != null : !((Object)this$chunkPosQueue).equals(other$chunkPosQueue)) {
            return false;
        }
        List<class_2338> this$blockPosQueue = this.getBlockPosQueue();
        List<class_2338> other$blockPosQueue = other.getBlockPosQueue();
        if (this$blockPosQueue == null ? other$blockPosQueue != null : !((Object)this$blockPosQueue).equals(other$blockPosQueue)) {
            return false;
        }
        Optional<class_2338> this$result = this.getResult();
        Optional<class_2338> other$result = other.getResult();
        return !(this$result == null ? other$result != null : !((Object)this$result).equals(other$result));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PositionSearchContext;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getAttempts();
        class_3222 $player = this.getPlayer();
        result = result * 59 + ($player == null ? 43 : $player.hashCode());
        RandomTeleportSettings $settings = this.getSettings();
        result = result * 59 + ($settings == null ? 43 : ((Object)$settings).hashCode());
        List<class_1923> $chunkPosQueue = this.getChunkPosQueue();
        result = result * 59 + ($chunkPosQueue == null ? 43 : ((Object)$chunkPosQueue).hashCode());
        List<class_2338> $blockPosQueue = this.getBlockPosQueue();
        result = result * 59 + ($blockPosQueue == null ? 43 : ((Object)$blockPosQueue).hashCode());
        Optional<class_2338> $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : ((Object)$result).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PositionSearchContext(player=" + String.valueOf(this.getPlayer()) + ", settings=" + String.valueOf(this.getSettings()) + ", chunkPosQueue=" + String.valueOf(this.getChunkPosQueue()) + ", blockPosQueue=" + String.valueOf(this.getBlockPosQueue()) + ", attempts=" + this.getAttempts() + ", result=" + String.valueOf(this.getResult()) + ")";
    }
}

