/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.structure;

import java.util.HashMap;
import java.util.Map;
import lombok.Generated;

public class Cooldown<T> {
    private final Map<T, Long> timestamp = new HashMap<T, Long>();

    public long getRemainingTime(T key, Long cooldownPeriod) {
        long lastUseTime = this.getLastUseTime(key);
        long currentTime = System.currentTimeMillis();
        return cooldownPeriod - (currentTime - lastUseTime);
    }

    public long getLastUseTime(T key) {
        return this.timestamp.computeIfAbsent(key, k -> 0L);
    }

    public long tryUse(T key, Long cooldownPeriod) {
        long remainingTime = this.getRemainingTime(key, cooldownPeriod);
        if (remainingTime < 0L) {
            this.onUse(key);
        }
        return remainingTime;
    }

    private void onUse(T key) {
        this.timestamp.put(key, System.currentTimeMillis());
    }

    @Generated
    public Map<T, Long> getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Cooldown)) {
            return false;
        }
        Cooldown other = (Cooldown)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<T, Long> this$timestamp = this.getTimestamp();
        Map<T, Long> other$timestamp = other.getTimestamp();
        return !(this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Cooldown;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<T, Long> $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Cooldown(timestamp=" + String.valueOf(this.getTimestamp()) + ")";
    }

    @Generated
    public Cooldown() {
    }
}

