/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.afk.service;

import io.github.sakurawald.fuji.core.auxiliary.minecraft.PacketHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.PlayerHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.command.executor.CommandExecutor;
import io.github.sakurawald.fuji.core.command.executor.structure.ExtendedCommandSource;
import io.github.sakurawald.fuji.core.document.annotation.TestCase;
import io.github.sakurawald.fuji.core.event.annotation.EventConsumer;
import io.github.sakurawald.fuji.core.event.message.player.ModifyPlayerListNameEvent;
import io.github.sakurawald.fuji.core.event.message.player.PlayerJoinedEvent;
import io.github.sakurawald.fuji.core.extension.PlayerCombatExtension;
import io.github.sakurawald.fuji.module.initializer.afk.AfkInitializer;
import io.github.sakurawald.fuji.module.initializer.afk.config.model.AfkConfigModel;
import io.github.sakurawald.fuji.module.initializer.afk.structure.PlayerAfkState;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2703;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

public class AfkService {
    private static final ConcurrentHashMap<String, PlayerAfkState> playerPreviousInputCounterMap = new ConcurrentHashMap();

    @EventConsumer(injectorPriority=2000, consumerPriority=2000)
    @TestCase(action="Issue `/afk` and see the player list.", targets={"The display name of an afk player should be modified."})
    private static void modifyPlayerListName(ModifyPlayerListNameEvent event) {
        class_3222 player = event.getPlayer();
        if (AfkService.isAfk(player)) {
            class_2561 newValue = AfkService.getAfkText(player);
            event.setText(newValue);
        }
    }

    public static boolean isAfk(@NotNull class_3222 player) {
        return AfkService.getPlayerAfkState(player).isAfk();
    }

    public static void countAction(@NotNull class_3222 player) {
        PlayerAfkState playerAfkState = AfkService.getPlayerAfkState(player);
        if (playerAfkState.isAfk()) {
            AfkService.changeAfk(player, false);
        }
    }

    @NotNull
    public static class_2561 getAfkText(@NotNull class_3222 player) {
        return TextHelper.getTextByValue(player, AfkInitializer.config.model().afk_display_name_format, new Object[0]);
    }

    public static boolean isPlayerMovedBySelf(@NotNull class_1313 movementType, @NotNull class_243 vec3d) {
        if (movementType == class_1313.field_6305) {
            return Double.compare(vec3d.field_1352, 0.0) != 0 || Double.compare(vec3d.field_1351, 0.0) != 0 || Double.compare(vec3d.field_1350, 0.0) != 0;
        }
        return false;
    }

    @NotNull
    private static PlayerAfkState getPlayerAfkState(@NotNull class_3222 player) {
        String playerName = PlayerHelper.getPlayerName((class_1657)player);
        return playerPreviousInputCounterMap.computeIfAbsent(playerName, k -> new PlayerAfkState());
    }

    private static void resetPlayerAfkState(@NotNull class_3222 player) {
        String playerName = PlayerHelper.getPlayerName((class_1657)player);
        playerPreviousInputCounterMap.put(playerName, new PlayerAfkState());
    }

    public static long getPreviousInputCounter(@NotNull class_3222 player) {
        return AfkService.getPlayerAfkState(player).getPreviousInputCounter();
    }

    public static void setPreviousInputCounter(@NotNull class_3222 player, long value) {
        AfkService.getPlayerAfkState(player).setPreviousInputCounter(value);
    }

    public static void changeAfk(@NotNull class_3222 player, boolean flag) {
        if (flag && !AfkService.canEnterAfk(player)) {
            return;
        }
        PlayerAfkState playerAfkState = AfkService.getPlayerAfkState(player);
        playerAfkState.setAfk(flag);
        PacketHelper.sendPacketToAll(new class_2703(class_2703.class_5893.field_29139, player));
        AfkConfigModel.AfkEvent afkEvent = AfkInitializer.config.model().afk_event;
        List<String> commandList = playerAfkState.isAfk() ? afkEvent.on_enter_afk : afkEvent.on_leave_afk;
        CommandExecutor.executeBatch(ExtendedCommandSource.asConsole(player.method_5671()), commandList);
    }

    public static boolean canEnterAfk(@NotNull class_3222 player) {
        return PlayerHelper.isRealPlayer(player) && !player.method_5809() && !player.field_27857 && !((PlayerCombatExtension)player).fuji$inCombat();
    }

    @EventConsumer
    private static void consumePlayerJoinedEvent(PlayerJoinedEvent event) {
        AfkService.resetPlayerAfkState(event.getPlayer());
    }
}

