/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.chat.replace;

import io.github.sakurawald.fuji.core.auxiliary.LogUtil;
import io.github.sakurawald.fuji.core.auxiliary.StringUtil;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.config.handler.abst.BaseConfigurationHandler;
import io.github.sakurawald.fuji.core.config.handler.impl.ObjectConfigurationHandler;
import io.github.sakurawald.fuji.core.document.annotation.ColorBox;
import io.github.sakurawald.fuji.core.document.annotation.ColorBoxes;
import io.github.sakurawald.fuji.core.document.annotation.Document;
import io.github.sakurawald.fuji.core.document.annotation.TestCase;
import io.github.sakurawald.fuji.core.event.annotation.EventConsumer;
import io.github.sakurawald.fuji.core.event.message.player.PlayerChatMessagePreEvent;
import io.github.sakurawald.fuji.core.structure.RegexRewriteNode;
import io.github.sakurawald.fuji.module.initializer.ModuleInitializer;
import io.github.sakurawald.fuji.module.initializer.chat.replace.model.ChatReplaceConfigModel;
import java.util.regex.Pattern;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_7471;
import org.jetbrains.annotations.NotNull;

@Document(id=1751826656743L, value="This module allows you to replace `chat string` with a given `chat text`. (Including placeholder parsing)\n")
@ColorBoxes(value={@ColorBox(id=1751870539707L, color=ColorBox.ColorBoxTypes.WARNING, value="\u25c9 This module didn't work with `Styled Chat` mod.\nThe `chat.replace` module does work with `chat.style` module.\nBut if you are using the `Styled Chat` mod, then it didn't work.\nHowever, since `Styled Chat` mod allows you to define custom `emotions`.\nSo you can `disable` this module, if you are using that mod.\n"), @ColorBox(id=1751899554713L, color=ColorBox.ColorBoxTypes.EXAMPLE, value="\u25c9 Define a chat shortcut, to evaluate a placeholder.\nRegex: `(?<=^|\\\\s)uuid(?=\\\\s|$)`\nReplacement: `my uuid is %player:uuid%`\n")})
public class ChatReplaceInitializer
extends ModuleInitializer {
    private static final BaseConfigurationHandler<ChatReplaceConfigModel> config = ObjectConfigurationHandler.ofModule("config.json", ChatReplaceConfigModel.class);

    @TestCase(action="Test the `chat replace` and `chat trigger` module.", targets={"Input `inv`", "Input `prefix inv`", "Input `prefix inv<space>`", "Input `inv suffix`", "Input `prefix inv item ender suffix inv suffix`", "Input `prefix prefix item`"})
    public static class_2561 replaceChatText(@NotNull class_1657 player, @NotNull class_2561 oldText) {
        class_5250 newText = oldText.method_27661();
        for (RegexRewriteNode rule : config.model().getReplace().getRules()) {
            Pattern cachedPattern = rule.getCachedPattern();
            newText = TextHelper.Replacer.replaceTextWithPattern((class_2561)newText, cachedPattern, matcher -> {
                String replacement = rule.getReplacement();
                replacement = StringUtil.copyMatcherAndReplaceFirst(cachedPattern, matcher, replacement);
                return TextHelper.getTextByValue(player, replacement, new Object[0]);
            });
        }
        LogUtil.debug("Replace chat text: old = {}, new = {}", oldText, newText);
        return newText;
    }

    @EventConsumer(injectorPriority=2000)
    private static void handleOnPlayerChatEvent(PlayerChatMessagePreEvent event) {
        class_7471 signedMessage = event.getSignedMessage();
        class_2561 oldValue = signedMessage.method_46291();
        class_2561 newValue = ChatReplaceInitializer.replaceChatText((class_1657)event.getPlayer(), oldValue);
        class_7471 newSignedMessage = signedMessage.method_44863(newValue);
        event.setSignedMessage(newSignedMessage);
    }
}

