/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.chat.trigger;

import io.github.sakurawald.fuji.core.auxiliary.LogUtil;
import io.github.sakurawald.fuji.core.auxiliary.StringUtil;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.command.executor.CommandExecutor;
import io.github.sakurawald.fuji.core.command.executor.structure.ExtendedCommandSource;
import io.github.sakurawald.fuji.core.config.handler.abst.BaseConfigurationHandler;
import io.github.sakurawald.fuji.core.config.handler.impl.ObjectConfigurationHandler;
import io.github.sakurawald.fuji.core.document.annotation.ColorBox;
import io.github.sakurawald.fuji.core.document.annotation.ColorBoxes;
import io.github.sakurawald.fuji.core.document.annotation.Document;
import io.github.sakurawald.fuji.core.event.annotation.EventConsumer;
import io.github.sakurawald.fuji.core.event.message.player.PlayerChatMessagePostEvent;
import io.github.sakurawald.fuji.module.initializer.ModuleInitializer;
import io.github.sakurawald.fuji.module.initializer.chat.trigger.config.model.ChatTriggerConfigModel;
import java.util.List;
import java.util.regex.Matcher;
import net.minecraft.class_2168;
import net.minecraft.class_7471;
import org.jetbrains.annotations.NotNull;

@Document(id=1751826730890L, value="This module allows you to define magic spells in chat, to execute commands.\n")
@ColorBoxes(value={@ColorBox(id=1754612494551L, color=ColorBox.ColorBoxTypes.TIP, value="\u25c9 Use `chat.trigger` to create `chat commands`.\nThe `regex` in `chat.replace` is used to `find` the target pattern in `the given string`.\nThe `regex` in `chat.trigger` is used to `match` the target pattern against `the given string`.\n\nYou can define a `chat command` like `!report` or `!noclip` in other games.\n"), @ColorBox(id=1751899049909L, color=ColorBox.ColorBoxTypes.EXAMPLE, value="\u25c9 To define a simple magic spell in chat string.\nRegex: `magic`\nCommands: `say magic!`\n"), @ColorBox(id=1751899198263L, color=ColorBox.ColorBoxTypes.EXAMPLE, value="\u25c9 To define a complex magic spell with arguments in chat string.\nRegex: `i am (.+)`\nCommands:\n1. `say You just said: $0`\n2. `say Hello $1`\n"), @ColorBox(id=1751899201560L, color=ColorBox.ColorBoxTypes.EXAMPLE, value="\u25c9 To define a shortcut for chat display module with Styled Chat mod.\nRegex: `(?<=^|\\\\s)item(?=\\\\s|$)`\nCommands: `run as fake-op %player:name% chat display item`\n")})
public class ChatTriggerInitializer
extends ModuleInitializer {
    private static final BaseConfigurationHandler<ChatTriggerConfigModel> config = ObjectConfigurationHandler.ofModule("config.json", ChatTriggerConfigModel.class);

    private static void processChatTriggers(@NotNull class_2168 source, @NotNull String chatString) {
        LogUtil.debug("Process chat triggers for input: chatString = {}", chatString);
        config.model().getTriggers().stream().filter(it -> it.getCachedPattern().matcher(chatString).matches()).forEach(chatTrigger -> {
            Matcher matcher = chatTrigger.getCachedPattern().matcher(chatString);
            List<String> commands = chatTrigger.getCommands().stream().map(cmd -> StringUtil.replaceAllAndResetMatcher(matcher, cmd)).toList();
            CommandExecutor.executeBatch(ExtendedCommandSource.asConsole(source), commands);
        });
    }

    @EventConsumer(injectorPriority=2000, consumerPriority=2000)
    private static void handleOnPlayerChatEvent(PlayerChatMessagePostEvent event) {
        class_7471 signedMessage = event.getSignedMessage();
        String chatString = TextHelper.Operators.getString(signedMessage.method_46291());
        ChatTriggerInitializer.processChatTriggers(event.getPlayer().method_5671(), chatString);
    }
}

