/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.command_alias;

import com.mojang.brigadier.context.CommandContext;
import io.github.sakurawald.fuji.core.annotation.Unused;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.ServerHelper;
import io.github.sakurawald.fuji.core.command.annotation.CommandNode;
import io.github.sakurawald.fuji.core.command.annotation.CommandRequirement;
import io.github.sakurawald.fuji.core.command.annotation.CommandSource;
import io.github.sakurawald.fuji.core.config.handler.abst.BaseConfigurationHandler;
import io.github.sakurawald.fuji.core.config.handler.impl.ObjectConfigurationHandler;
import io.github.sakurawald.fuji.core.document.annotation.ColorBox;
import io.github.sakurawald.fuji.core.document.annotation.ColorBoxes;
import io.github.sakurawald.fuji.core.document.annotation.Document;
import io.github.sakurawald.fuji.core.document.gui.CommandsInspectionGui;
import io.github.sakurawald.fuji.core.event.annotation.EventConsumer;
import io.github.sakurawald.fuji.core.event.message.server.command.CommandRegistrationEvent;
import io.github.sakurawald.fuji.core.event.message.server.lifecycle.ServerStartedEvent;
import io.github.sakurawald.fuji.module.initializer.ModuleInitializer;
import io.github.sakurawald.fuji.module.initializer.command_alias.config.model.CommandAliasConfigModel;
import io.github.sakurawald.fuji.module.initializer.command_alias.service.CommandAliasService;
import io.github.sakurawald.fuji.module.initializer.command_alias.structure.AliasCommandDescriptor;
import net.minecraft.class_2168;

@Document(id=1751826302190L, value="This module allows you to define alias for existing commands.\nThe defined alies command will redirect to the existing command node.\n")
@ColorBoxes(value={@ColorBox(id=1751900420030L, color=ColorBox.ColorBoxTypes.EXAMPLE, value="\u25c9 Define a `new shortcut command` as an alias to `an existing command`.\nFor example:\n1. Define a new `/r` command, as alias to `/reply` command.\n2. Define a new `/sudo` command, as alias to `/run as fake-op` command.\n"), @ColorBox(id=1751900579678L, color=ColorBox.ColorBoxTypes.TIP, value="The `command_alias` command only has the ability to define `a new command`, as the alias of `an existing command`.\nIt works by `command redirecting`.\nYou can't use `command_alias` module to actually define `a new command with arguments`, that's the weakness.\nIf you want to define `a new command with arguments`, see `command_bundle` module.\n\nIn short:\n1. To define `a simple command` with no arguments, use `command_alias` module.\n2. To define `a complex command` with arguments, use `command_bundle` module.\n")})
@CommandNode(value="command-alias")
@CommandRequirement(level=4)
public class CommandAliasInitializer
extends ModuleInitializer {
    public static final BaseConfigurationHandler<CommandAliasConfigModel> config = ObjectConfigurationHandler.ofModule("config.json", CommandAliasConfigModel.class);

    @Document(id=1756022056042L, value="List all registered alias-commands in server.")
    @CommandNode(value="list")
    private static int $list(@CommandSource CommandContext<class_2168> ctx) {
        return CommandsInspectionGui.inspectCommandDescriptors(ctx, it -> it instanceof AliasCommandDescriptor);
    }

    @EventConsumer
    private static void registerAllAliasCommands(@Unused ServerStartedEvent event) {
        CommandAliasService.registerAllAliasCommands();
    }

    @EventConsumer
    private static void onCommandRegistrationEvent(@Unused CommandRegistrationEvent event) {
        ServerHelper.withServerInstantiated(() -> CommandAliasService.registerAllAliasCommands());
    }

    @Override
    protected void onReload() {
        CommandAliasService.unregisterAllAliasCommands();
        CommandAliasService.registerAllAliasCommands();
    }
}

