/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.command_attachment;

import io.github.sakurawald.fuji.core.auxiliary.minecraft.CommandHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.EntityHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.ItemStackHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.UuidHelper;
import io.github.sakurawald.fuji.core.command.annotation.CommandNode;
import io.github.sakurawald.fuji.core.command.annotation.CommandRequirement;
import io.github.sakurawald.fuji.core.command.annotation.CommandSource;
import io.github.sakurawald.fuji.core.command.argument.wrapper.impl.GreedyString;
import io.github.sakurawald.fuji.core.config.handler.abst.BaseConfigurationHandler;
import io.github.sakurawald.fuji.core.config.handler.impl.ObjectConfigurationHandler;
import io.github.sakurawald.fuji.core.config.mapper.GsonMapper;
import io.github.sakurawald.fuji.core.document.annotation.ColorBox;
import io.github.sakurawald.fuji.core.document.annotation.ColorBoxes;
import io.github.sakurawald.fuji.core.document.annotation.Document;
import io.github.sakurawald.fuji.core.event.annotation.EventConsumer;
import io.github.sakurawald.fuji.core.event.message.player.PlayerActionEvent;
import io.github.sakurawald.fuji.core.event.message.player.PlayerBlockBreakPreEvent;
import io.github.sakurawald.fuji.core.event.message.player.PlayerInteractBlockPreEvent;
import io.github.sakurawald.fuji.core.event.message.player.PlayerInteractEntityPreEvent;
import io.github.sakurawald.fuji.core.event.message.player.PlayerInteractItemPreEvent;
import io.github.sakurawald.fuji.module.initializer.ModuleInitializer;
import io.github.sakurawald.fuji.module.initializer.command_attachment.command.argument.wrapper.ExecuteAsType;
import io.github.sakurawald.fuji.module.initializer.command_attachment.command.argument.wrapper.InteractType;
import io.github.sakurawald.fuji.module.initializer.command_attachment.config.adapter.CommandAttachmentEntryAdapter;
import io.github.sakurawald.fuji.module.initializer.command_attachment.config.model.CommandAttachmentConfigModel;
import io.github.sakurawald.fuji.module.initializer.command_attachment.config.model.CommandAttachmentDataModel;
import io.github.sakurawald.fuji.module.initializer.command_attachment.config.transformer.CommandAttachmentV1SchemaTransformer;
import io.github.sakurawald.fuji.module.initializer.command_attachment.gui.CommandAttachmentEditorGui;
import io.github.sakurawald.fuji.module.initializer.command_attachment.job.TestSteppingOnBlockJob;
import io.github.sakurawald.fuji.module.initializer.command_attachment.service.CommandAttachmentService;
import io.github.sakurawald.fuji.module.initializer.command_attachment.structure.CommandAttachments;
import io.github.sakurawald.fuji.module.initializer.command_attachment.structure.attachment_entry.BaseCommandAttachmentEntry;
import io.github.sakurawald.fuji.module.initializer.command_attachment.structure.attachment_entry.BlockCommandAttachmentEntry;
import io.github.sakurawald.fuji.module.initializer.command_attachment.structure.attachment_entry.EntityCommandAttachmentEntry;
import io.github.sakurawald.fuji.module.initializer.command_attachment.structure.attachment_entry.ItemStackCommandAttachmentEntry;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_2846;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

@Document(id=1751826430284L, value="This module allows you to attach commands into things:\n1. Attach commands into an item stack.\n2. Attach commands into a block.\n3. Attach commands into an entity.\n")
@ColorBoxes(value={@ColorBox(id=1751870462624L, color=ColorBox.ColorBoxTypes.NOTE, value="\u25c9 How it works?\nWhen you attach commands into an item.\nWe will save a `binding ID` in the item NBT.\nEvery item that has the same `binding ID` in its NBT data, shares the same `binding commands instance`.\n"), @ColorBox(id=1756447342634L, color=ColorBox.ColorBoxTypes.NOTE, value="\u25c9 Valid `interaction types` for each `attached types`.\n- `item`: `LEFT_CLICK`, `RIGHT_CLICK`, `ANY_CLICK`, `SWAP_HAND`\n- `block`: `LEFT_CLICK`, `RIGHT_CLICK`, `ANY_CLICK`, `STEP_ON`\n- `entity`: `RIGHT_CLICK`, `ANY_CLICK`\n"), @ColorBox(id=1751870464919L, color=ColorBox.ColorBoxTypes.TIP, value="\u25c9 Give the `attached item` to players.\nYou can use `kit` module.\nThe kit module will save the item NBT.\nSo if you define a kit, puts `the attached item` inside it.\nThen give the kit to a player.\nThe player will get the magic item.\n"), @ColorBox(id=1756460500752L, color=ColorBox.ColorBoxTypes.TIP, value="\u25c9 Integrate with `command_cooldown` module.\nYou can use `command_cooldown` module to create a `named cooldown`.\nThe `named cooldown` can restrict the `use interval` and `use times` of a specified command.\nAnd then, attach the `named cooldown test command` to an `item` using `command_attachment` module.\n"), @ColorBox(id=1756458386657L, color=ColorBox.ColorBoxTypes.EXAMPLE, value="\u25c9 Make a magic-stick, which heals the player on clicked.\nIssue `/command-attachment attach-item-one heal`\n\n\u25c9 Make a magic-stick, which:\n1. Gives diamonds * 1 on left clicked. (With use limit 3)\n2. Gives gold_ingot *1 on right clicked. (With use limit 5)\n\nIssue the following commands:\n1. `/command-attachment attach-item-one --maxUseTimes 3 --interactType LEFT_CLICK give %player:name% minecraft:diamond 1`\n2. `/command-attachment attach-item-one --maxUseTimes 5 --interactType RIGHT_CLICK give %player:name% minecraft:gold_ingot 1`\n\n\u25c9 Make a magic-stick, which gives apple * 1, with use limit 3 times, and keep the item without destroying it.\nIssue: `/command-attachment attach-item-one --maxUseTimes 3 --destroyItem false give %player:name% minecraft:apple 1`.\n\n\u25c9 Query the attached commands in a specific item.\nIssue `/command-attachment query-item`.\n\n\u25c9 Let an entity say hello on right clicked.\nIssue: `/command-attachment attach-entity-one \\<entity-id\\> say hello %player:name%`\n\n\u25c9 Make a portal block.\nIssue: `/command-attachment attach-block-one 0 0 0 --interactType STEP_ON tppos --targetPlayer %player:name% --dimension minecraft:the_end --x 0 --y 66 --z 0 %player:name%`.\n\n\u25c9 View and edit the attached object.\nIssue: `/command-attachment editor`\n")})
@CommandNode(value="command-attachment")
@CommandRequirement(level=4)
public class CommandAttachmentInitializer
extends ModuleInitializer {
    public static final BaseConfigurationHandler<CommandAttachmentConfigModel> config = ObjectConfigurationHandler.ofModule("config.json", CommandAttachmentConfigModel.class);
    public static final BaseConfigurationHandler<CommandAttachmentDataModel> data = ObjectConfigurationHandler.ofModule("command-attachment-data.json", CommandAttachmentDataModel.class).enableAutoSaveFeature().installTransformer(new CommandAttachmentV1SchemaTransformer());

    @Document(id=1751826433455L, value="Attach one command to an item.")
    @CommandNode(value="attach-item-one")
    private static int $attachItemOne(@CommandSource class_3222 player, Optional<InteractType> interactType, Optional<Integer> maxUseTimes, Optional<ExecuteAsType> executeAsType, Optional<Boolean> destroyItem, GreedyString command) {
        return CommandHelper.Pattern.withItemInMainHand(player.method_5671(), (thePlayer, mainHandStack) -> {
            String uuid = UuidHelper.getOrSetAttachedUuid(mainHandStack);
            return CommandAttachmentService.withAttachmentDataNode(uuid, it -> {
                CommandAttachments model = it.getAttachments();
                String $command = (String)command.getValue();
                InteractType $interactType = interactType.orElse(InteractType.ANY_CLICK);
                ExecuteAsType $executeAsType = executeAsType.orElse(ExecuteAsType.FAKE_OP);
                Integer $maxUseTimes = maxUseTimes.orElse(Integer.MAX_VALUE);
                Boolean $destroyItem = destroyItem.orElse(true);
                ItemStackCommandAttachmentEntry newEntry = new ItemStackCommandAttachmentEntry($command, $interactType, $executeAsType, $maxUseTimes, 0, $destroyItem);
                model.getEntries().add(newEntry);
                return 1;
            });
        });
    }

    @Document(id=1751826450179L, value="Attach one command to an entity.")
    @CommandNode(value="attach-entity-one")
    private static int $attachEntityOne(@CommandSource class_3222 player, class_1297 entity, Optional<InteractType> interactType, Optional<Integer> maxUseTimes, Optional<ExecuteAsType> executeAsType, GreedyString command) {
        String uuid = UuidHelper.getAttachedUuid(entity);
        return CommandAttachmentService.withAttachmentDataNode(uuid, it -> {
            CommandAttachments model = it.getAttachments();
            String $command = (String)command.getValue();
            InteractType $interactType = interactType.orElse(InteractType.ANY_CLICK);
            ExecuteAsType $executeAsType = executeAsType.orElse(ExecuteAsType.FAKE_OP);
            Integer $maxUseTimes = maxUseTimes.orElse(Integer.MAX_VALUE);
            EntityCommandAttachmentEntry newEntry = new EntityCommandAttachmentEntry($command, $interactType, $executeAsType, $maxUseTimes, 0, false);
            model.getEntries().add(newEntry);
            return 1;
        });
    }

    @Document(id=1751826465183L, value="Attach one command to specified block.")
    @CommandNode(value="attach-block-one")
    private static int $attachBlockOne(@CommandSource class_3222 player, class_2338 blockPos, Optional<InteractType> interactType, Optional<Integer> maxUseTimes, Optional<ExecuteAsType> executeAsType, GreedyString command) {
        String uuid = UuidHelper.getAttachedUuid((class_1937)EntityHelper.getServerWorld((class_1297)player), blockPos);
        return CommandAttachmentService.withAttachmentDataNode(uuid, it -> {
            CommandAttachments model = it.getAttachments();
            String $command = (String)command.getValue();
            InteractType $interactType = interactType.orElse(InteractType.ANY_CLICK);
            ExecuteAsType $executeAsType = executeAsType.orElse(ExecuteAsType.FAKE_OP);
            Integer $maxUseTimes = maxUseTimes.orElse(Integer.MAX_VALUE);
            String createdIn = UuidHelper.toString(player.method_37908(), blockPos);
            BlockCommandAttachmentEntry newEntry = new BlockCommandAttachmentEntry(createdIn, $command, $interactType, $executeAsType, (int)$maxUseTimes, 0, false);
            model.getEntries().add(newEntry);
            return 1;
        });
    }

    @Document(id=1751826477036L, value="Detach all attached commands in the item.")
    @CommandNode(value="detach-item-all")
    private static int $detachItemAll(@CommandSource class_3222 player, Optional<Boolean> confirm) {
        return CommandHelper.Pattern.withCommandConfirmed(player, confirm, () -> CommandHelper.Pattern.withItemInMainHand(player.method_5671(), (thePlayer, mainHandStack) -> {
            String uuid = UuidHelper.getOrSetAttachedUuid(mainHandStack);
            CommandAttachmentService.removeAttachmentDataNode(uuid);
            return 1;
        }));
    }

    @Document(id=1751826478770L, value="Detach all attached commands in the entity.")
    @CommandNode(value="detach-entity-all")
    private static int $detachEntityAll(@CommandSource class_3222 player, class_1297 entity, Optional<Boolean> confirm) {
        return CommandHelper.Pattern.withCommandConfirmed(player, confirm, () -> {
            String uuid = UuidHelper.getAttachedUuid(entity);
            CommandAttachmentService.removeAttachmentDataNode(uuid);
            return 1;
        });
    }

    @Document(id=1751826482248L, value="Detach all attached commands in the block.")
    @CommandNode(value="detach-block-all")
    private static int $detachBlockAll(@CommandSource class_3222 player, class_2338 blockPos, Optional<Boolean> confirm) {
        return CommandHelper.Pattern.withCommandConfirmed(player, confirm, () -> {
            String uuid = UuidHelper.getAttachedUuid((class_1937)EntityHelper.getServerWorld((class_1297)player), blockPos);
            CommandAttachmentService.removeAttachmentDataNode(uuid);
            return 1;
        });
    }

    @Document(id=1751826486559L, value="Query all attached commands in the item.")
    @CommandNode(value="query-item")
    private static int $queryItem(@CommandSource class_3222 player) {
        return CommandHelper.Pattern.withItemInMainHand(player.method_5671(), (thePlayer, mainHandStack) -> {
            Optional<String> uuid = UuidHelper.getAttachedUuid(mainHandStack);
            return CommandAttachmentService.printAttachmentDataNode(player.method_5671(), uuid);
        });
    }

    @Document(id=1751826488228L, value="Query all attached commands in the entity.")
    @CommandNode(value="query-entity")
    private static int $queryEntity(@CommandSource class_2168 source, class_1297 entity) {
        String uuid = UuidHelper.getAttachedUuid(entity);
        return CommandAttachmentService.printAttachmentDataNode(source, Optional.of(uuid));
    }

    @Document(id=1751826492923L, value="Query all attached commands in the block.")
    @CommandNode(value="query-block")
    private static int $queryBlock(@CommandSource class_2168 source, class_2338 blockPos) {
        String uuid = UuidHelper.getAttachedUuid((class_1937)source.method_9225(), blockPos);
        return CommandAttachmentService.printAttachmentDataNode(source, Optional.of(uuid));
    }

    @Document(id=1756452396077L, value="Open the command attachment editor.")
    @CommandNode(value="editor")
    private static int $editor(@CommandSource class_3222 player) {
        CommandAttachmentEditorGui.make(player).open();
        return 1;
    }

    @Override
    protected void onInitialize() {
        TestSteppingOnBlockJob.reloadJob();
    }

    @Override
    protected void onReload() {
        TestSteppingOnBlockJob.reloadJob();
    }

    @Override
    protected void registerGsonTypeAdapters() {
        GsonMapper.registerGsonTypeAdapter(BaseCommandAttachmentEntry.class, new CommandAttachmentEntryAdapter());
    }

    @EventConsumer
    private static void consumePlayerActionEvent(PlayerActionEvent event) {
        class_2846 packet = event.getPacket();
        if (packet.method_12363() == class_2846.class_2847.field_12969) {
            class_3222 player = event.getPlayer();
            class_1799 itemStack = player.method_6047();
            UuidHelper.getAttachedUuid(ItemStackHelper.CustomData.getCustomDataNbt(itemStack)).ifPresent($uuid -> CommandAttachmentService.tryTriggerAttachmentDataNode($uuid, (class_1657)player, List.of(InteractType.SWAP_HAND), () -> event.getCallbackInfo().cancel()));
        }
    }

    @EventConsumer
    private static void consumePlayerBlockBreakPreEvent(PlayerBlockBreakPreEvent event) {
        if (event.getCallbackInfoReturnable().isCancelled()) {
            return;
        }
        class_3222 player = event.getPlayer();
        class_3218 world = EntityHelper.getServerWorld((class_1297)player);
        String uuid = UuidHelper.getAttachedUuid((class_1937)world, event.getBlockPos());
        CommandAttachmentService.findAttachmentDataNode(uuid).ifPresent(it -> {
            event.getCallbackInfoReturnable().setReturnValue((Object)false);
            TextHelper.sendTextByKey(player, "command_attachment.protect", new Object[0]);
        });
    }

    @EventConsumer
    private static void consumePlayerInteractItemPreEvent(PlayerInteractItemPreEvent event) {
        if (event.getCallbackInfoReturnable().isCancelled()) {
            return;
        }
        UuidHelper.getAttachedUuid(ItemStackHelper.CustomData.getCustomDataNbt(event.getItemStack())).ifPresent($uuid -> CommandAttachmentService.tryTriggerAttachmentDataNode($uuid, (class_1657)event.getPlayer(), List.of(InteractType.RIGHT_CLICK, InteractType.ANY_CLICK), () -> {}));
    }

    @EventConsumer(injectorPriority=999, consumerPriority=0)
    private static void consumePlayerInteractBlockPreEvent(PlayerInteractBlockPreEvent event) {
        if (event.getCallbackInfoReturnable().isCancelled()) {
            return;
        }
        if (event.getHand() == class_1268.field_5808) {
            String uuid = UuidHelper.getAttachedUuid(event.getWorld(), event.getBlockHitResult().method_17777());
            CommandAttachmentService.tryTriggerAttachmentDataNode(uuid, (class_1657)event.getPlayer(), List.of(InteractType.RIGHT_CLICK, InteractType.ANY_CLICK), () -> event.getCallbackInfoReturnable().setReturnValue((Object)class_1269.field_5814));
        }
    }

    @EventConsumer(injectorPriority=999, consumerPriority=0)
    private static void consumePlayerInteractEntityPreEvent(PlayerInteractEntityPreEvent event) {
        if (event.getCallbackInfoReturnable().isCancelled()) {
            return;
        }
        if (event.getHand() == class_1268.field_5808) {
            String uuid = event.getEntity().method_5845();
            CommandAttachmentService.tryTriggerAttachmentDataNode(uuid, (class_1657)event.getPlayer(), List.of(InteractType.RIGHT_CLICK, InteractType.ANY_CLICK), () -> {});
        }
    }
}

