/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.command_attachment.job;

import io.github.sakurawald.fuji.core.auxiliary.minecraft.EntityHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.PlayerHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.ServerHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.UuidHelper;
import io.github.sakurawald.fuji.core.document.annotation.Document;
import io.github.sakurawald.fuji.core.job.abst.FixedIntervalJob;
import io.github.sakurawald.fuji.core.manager.Managers;
import io.github.sakurawald.fuji.module.initializer.command_attachment.CommandAttachmentInitializer;
import io.github.sakurawald.fuji.module.initializer.command_attachment.command.argument.wrapper.InteractType;
import io.github.sakurawald.fuji.module.initializer.command_attachment.service.CommandAttachmentService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.quartz.JobExecutionContext;

@Document(id=1751826425009L, value="This `job` is used to test if the player is stepping on a `block` with `attached commands`.\n")
public class TestSteppingOnBlockJob
extends FixedIntervalJob {
    private static final Map<String, String> player2lastSteppingBlockUUID = new HashMap<String, String>();

    public TestSteppingOnBlockJob() {
        super(null, null, null, TestSteppingOnBlockJob.intervalSupplier(), -1);
        this.rescheduleAble = false;
    }

    private static void scheduleJob() {
        TestSteppingOnBlockJob job = new TestSteppingOnBlockJob();
        Managers.getScheduleManager().scheduleJob(job);
    }

    public static void reloadJob() {
        Managers.getScheduleManager().deleteJobs(TestSteppingOnBlockJob.class);
        TestSteppingOnBlockJob.scheduleJob();
    }

    private static int intervalSupplier() {
        return CommandAttachmentInitializer.config.model().getTestSteppingOnBlockIntervalInMillSeconds();
    }

    private static void testSteppingBlockForPlayer(@NotNull class_3222 player) {
        String playerName = PlayerHelper.getPlayerName((class_1657)player);
        String lastSteppingBlockUUID = player2lastSteppingBlockUUID.get(playerName);
        class_3218 serverWorld = EntityHelper.getServerWorld((class_1297)player);
        String currentSteppingBlockUUID = UuidHelper.getAttachedUuid((class_1937)serverWorld, player.method_23312());
        if (currentSteppingBlockUUID.equals(lastSteppingBlockUUID)) {
            return;
        }
        player2lastSteppingBlockUUID.put(playerName, currentSteppingBlockUUID);
        ServerHelper.executeSync(() -> CommandAttachmentService.tryTriggerAttachmentDataNode(currentSteppingBlockUUID, (class_1657)player, List.of(InteractType.STEP_ON), () -> {}));
    }

    private static void testSteppingBlockForPlayers() {
        PlayerHelper.Lookup.getOnlinePlayers().forEach(TestSteppingOnBlockJob::testSteppingBlockForPlayer);
    }

    public void execute(JobExecutionContext context) {
        TestSteppingOnBlockJob.testSteppingBlockForPlayers();
    }
}

