/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.command_attachment.service;

import io.github.sakurawald.fuji.core.auxiliary.minecraft.CommandHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.ServerHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.command.exception.AbortCommandExecutionException;
import io.github.sakurawald.fuji.core.command.executor.CommandExecutor;
import io.github.sakurawald.fuji.core.command.executor.structure.ExtendedCommandSource;
import io.github.sakurawald.fuji.core.config.mapper.GsonMapper;
import io.github.sakurawald.fuji.module.initializer.command_attachment.CommandAttachmentInitializer;
import io.github.sakurawald.fuji.module.initializer.command_attachment.command.argument.wrapper.ExecuteAsType;
import io.github.sakurawald.fuji.module.initializer.command_attachment.command.argument.wrapper.InteractType;
import io.github.sakurawald.fuji.module.initializer.command_attachment.structure.CommandAttachmentDataNode;
import io.github.sakurawald.fuji.module.initializer.command_attachment.structure.CommandAttachments;
import io.github.sakurawald.fuji.module.initializer.command_attachment.structure.attachment_entry.BaseCommandAttachmentEntry;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommandAttachmentService {
    public static <T> T withAttachmentDataNode(@NotNull String uuid, @NotNull Function<CommandAttachmentDataNode, T> function) {
        CommandAttachmentDataNode dataNode = CommandAttachmentService.findAttachmentDataNode(uuid).orElseGet(() -> {
            CommandAttachmentDataNode newValue = new CommandAttachmentDataNode();
            newValue.setId(uuid);
            CommandAttachmentService.listAttachmentDataNodes().add(newValue);
            return newValue;
        });
        return function.apply(dataNode);
    }

    public static Optional<CommandAttachmentDataNode> findAttachmentDataNode(@Nullable String uuid) {
        return CommandAttachmentService.listAttachmentDataNodes().stream().filter(it -> it.getId().equals(uuid)).findFirst();
    }

    private static List<CommandAttachmentDataNode> listAttachmentDataNodes() {
        return CommandAttachmentInitializer.data.model().getNodes();
    }

    public static void tryTriggerAttachmentDataNode(@Nullable String uuid, @NotNull class_1657 player, @NotNull List<InteractType> inputInteractTypes, @NotNull Runnable postTriggered) {
        CommandAttachmentService.findAttachmentDataNode(uuid).ifPresent(it -> CommandAttachmentService.tryTriggerCommandAttachments(it.getAttachments(), player, inputInteractTypes, postTriggered));
    }

    private static void tryTriggerCommandAttachments(@NotNull CommandAttachments attachments, @NotNull class_1657 player, @NotNull List<InteractType> inputInteractTypes, @NotNull Runnable triggeredHook) {
        ServerHelper.withServerPlayerEntity(player, serverPlayer -> {
            for (BaseCommandAttachmentEntry entry : attachments.getEntries()) {
                if (!inputInteractTypes.contains((Object)entry.getInteractType()) || entry.getUseTimes() >= entry.getMaxUseTimes()) continue;
                entry.onUsed((class_3222)player);
                ExecuteAsType executeAsType = entry.getExecuteAsType();
                class_2168 initialingCommandSource = CommandHelper.Source.getCommandSource(serverPlayer);
                switch (executeAsType) {
                    case CONSOLE: {
                        CommandExecutor.executeSingle(ExtendedCommandSource.asConsole(initialingCommandSource), entry.getCommand());
                        break;
                    }
                    case PLAYER: {
                        CommandExecutor.executeSingle(ExtendedCommandSource.asPlayer(initialingCommandSource, (class_3222)player), entry.getCommand());
                        break;
                    }
                    case FAKE_OP: {
                        CommandExecutor.executeSingle(ExtendedCommandSource.asFakeOp(initialingCommandSource, (class_3222)player), entry.getCommand());
                    }
                }
                triggeredHook.run();
            }
        });
    }

    public static void removeAttachmentDataNode(@NotNull String uuid) {
        CommandAttachmentService.listAttachmentDataNodes().removeIf(it -> it.getId().equals(uuid));
    }

    public static int printAttachmentDataNode(@NotNull class_2168 source, Optional<String> uuid) {
        return uuid.flatMap(CommandAttachmentService::findAttachmentDataNode).map(it -> {
            CommandAttachmentDataNode dataNode = it;
            String attachmentDataNode = GsonMapper.toJsonString(dataNode);
            TextHelper.sendMessageByText(source, (class_2561)class_2561.method_43470((String)attachmentDataNode));
            return 1;
        }).orElseThrow(() -> {
            TextHelper.sendTextByKey(source, "command_attachment.query.no_attachment", new Object[0]);
            return new AbortCommandExecutionException();
        });
    }
}

