/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.command_bundle;

import com.mojang.brigadier.context.CommandContext;
import io.github.sakurawald.fuji.core.annotation.Unused;
import io.github.sakurawald.fuji.core.auxiliary.LogUtil;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.CommandHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.ServerHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.command.annotation.CommandNode;
import io.github.sakurawald.fuji.core.command.annotation.CommandRequirement;
import io.github.sakurawald.fuji.core.command.annotation.CommandSource;
import io.github.sakurawald.fuji.core.command.descriptor.CommandDescriptor;
import io.github.sakurawald.fuji.core.command.processor.CommandAnnotationProcessor;
import io.github.sakurawald.fuji.core.config.handler.abst.BaseConfigurationHandler;
import io.github.sakurawald.fuji.core.config.handler.impl.ObjectConfigurationHandler;
import io.github.sakurawald.fuji.core.document.annotation.ColorBox;
import io.github.sakurawald.fuji.core.document.annotation.ColorBoxes;
import io.github.sakurawald.fuji.core.document.annotation.Document;
import io.github.sakurawald.fuji.core.document.annotation.TestCase;
import io.github.sakurawald.fuji.core.document.gui.CommandsInspectionGui;
import io.github.sakurawald.fuji.core.event.annotation.EventConsumer;
import io.github.sakurawald.fuji.core.event.message.server.command.CommandRegistrationEvent;
import io.github.sakurawald.fuji.core.event.message.server.lifecycle.ServerStartedEvent;
import io.github.sakurawald.fuji.module.initializer.ModuleInitializer;
import io.github.sakurawald.fuji.module.initializer.command_bundle.config.model.CommandBundleConfigModel;
import io.github.sakurawald.fuji.module.initializer.command_bundle.structure.BundleCommandDescriptor;
import java.util.List;
import net.minecraft.class_2168;
import org.jetbrains.annotations.NotNull;

@Document(id=1751826356909L, value="This module allows you to create new command:\n1. The new command can accept arguments.\n2. The body of the new command, can be a list of commands.\n")
@ColorBoxes(value={@ColorBox(id=1751870454656L, color=ColorBox.ColorBoxTypes.NOTE, value="\u25c9 The features of this module:\n1. Provide a user-friendly DSL, to create `a new custom command` easily.\n2. Support the inter-operation with `user-defined variable`, `placeholders` and `vanilla target selectors`.\n3. Support complex `argument types`: `required argument`, `literal argument` and even `optional argument with a specified default value`.\n4. A powerful `type-system`, to use the built-in `argument types`.\n5. Register and un-register `custom commands` on the fly, without a server re-start.\n"), @ColorBox(id=1751870456781L, color=ColorBox.ColorBoxTypes.NOTE, value="\u25c9 The `purpose` of this module\nThis module allows you to `define` a `new command`.\nTo `define` a new command, you need to specify the following things:\n1. The `pattern` of this new command: If the pattern is `claim-kit example`, then the new command is `/claim-kit example`.\n2. The `bundle` of this new command: It is the `body` of this new command. It is `a list of commands` to be executed.\n\n<green>To define a new `bundle command`, you need to specify the `pattern` and the `bundle` for it.\nThe `pattern` describes: what does your `new command` look like?\nThe `bundle` describes: what `commands` should we execute when your `new command` is executed?\n"), @ColorBox(id=1752892603255L, color=ColorBox.ColorBoxTypes.NOTE, value="\u25c9 The syntax of the `pattern`.\nThe `pattern` is composed by a list of `command node`.\nFor example, the `pattern` instance `first second third` describes a command `/first second third`.\nIt is composed by 3 `command node`, they are all `literal arguments`.\n\nIn the syntax of `pattern`, there are 3 types of `arguments`:\n1. `Literal Argument`: You can write it down directly. For example `first`, `second`, `third`, and `claim-kit` are all literal arguments.\n2. `Required Argument`: It's syntax is `\\<arg-type arg-name\\>`. For example, `\\<int age\\>` means a `required argument` whose `argument type is int` and `argument name is age`.\n3. `Optional Argument`: It's syntax is `[arg-type arg-name default-value]`. It is similar to `required argument`, but you can provide a `default value` if this argument is not specified by the `command source`.\n\nYou can `reference` the value of `Required Argument` or `Optional Argument` in the `bundle` component.\nFor example, you can write down `$age` to refer to a `variable` named `age` defined in the `pattern` component.\n\n\u25c9 What is the `type system` used by the syntax of `pattern`?\nFuji will register an `argument type adapter` for a specific `argument type`.\nYou can issue `/fuji inspect argument-types` to list all registered `adapters`.\nYou can use any `argument type` listed in that GUI.\n"), @ColorBox(id=1752893166889L, color=ColorBox.ColorBoxTypes.NOTE, value="\u25c9 The syntax of the `bundle`.\nActually, the `bundle` is just a `list of commands`.\nYou can write `Minecraft commands` directly in the `bundle` list.\n\nWhen a `bundle command` is executed, we will execute the `list of commands` defined by `bundle` from up to down.\nCommands are executed `as console`.\nYou can use `/run as player` or `/run as fake-op` to switch the command execution context, if it is needed.\n"), @ColorBox(id=1751870458514L, color=ColorBox.ColorBoxTypes.TIP, value="\u25c9 Generate powerful commands using a generator.\nYou can use command generator to get powerful commands:\nhttps://www.gamergeeks.net/apps/minecraft/particle-command-generator\n"), @ColorBox(id=1751901598337L, color=ColorBox.ColorBoxTypes.EXAMPLE, value="\u25c9 Use a `bundle command` to combine many commands into one command.\nIn this example, we want to register a new command `/composite-heal`.\nTo `decorate` an existed command `/heal`.\nThe decorations are:\n1. We will `say` before the execution of `/heal` command.\n2. We will spawn a `heart particle` before the execution of `/heal` command.\n3. We will `say` after the execution of `/heal` command.\n\nTo define this `bundle command` as shown below.\nPattern: `composite-heal`\nBundle:\n1. `say before heal %player:name%`\n2. `run as fake-op %player:name% particle minecraft:heart ~ ~2 ~`\n3. `run as player %player:name% heal`\n4. `say after heal %player:name%`\n"), @ColorBox(id=1751901750629L, color=ColorBox.ColorBoxTypes.EXAMPLE, value="\u25c9 Use a `bundle command` to transform the form of an existed command.\nIn this example, we want to register a new command `/warn`.\nAs a `shortcut command` to a specific command instance.\n\nPattern: `warn \\<player player-arg\\> \\<greedy greedy-arg\\>`\nBundle:\n1. `run as player %player:name% send-message $player-arg \\<red\\>You are warned: $greedy-arg`\n"), @ColorBox(id=1752894328505L, color=ColorBox.ColorBoxTypes.EXAMPLE, value="\u25c9 Use a `bundle command` to wrap a specific command instance.\nIn this example, if you want to allow players to use `/give @s minecraft:apple`.\nYou only want to allow the players to get free `apples`.\nAnd you didn't want to allow players to use `/give` command arbitrarily.\n\nThen, you can define a `bundle command` like `/free-apple` to `wrap` a specific instance of `/give` command.\nPattern: `free-apple`\nBundle:\n1. `run as fake-op %player:name% give @s minecraft:apple`\n\n\u25c9 Define a `bundle command` to wrap a specific `/kit give` command instance.\nPattern: `kitfood`\nBundle:\n1. `run as fake-op %player:name% kit give @s kit-food`\n"), @ColorBox(id=1752895095176L, color=ColorBox.ColorBoxTypes.EXAMPLE, value="\u25c9 See more advanced examples.\nThe default config file contains a set of `advanced examples`.\nYou can see there are many pre-defined `bundle commands`.\nTheir name starts with `/my-command`.\n\nBesides, there are also a set of pre-defined `bundle commands` for convenience.\nFor example: `/gmc`, `/gms`, `/day`, `/sun`...\n"), @ColorBox(id=1751983696805L, color=ColorBox.ColorBoxTypes.EXAMPLE, value="\u25c9 Transform the form of a command.\n- `/blocknbt` -> `/data get block`\n- `/entitynbt` -> `/data get entity`\n- `/gm`, `/gms` and `/gmc` -> `/gamemode`\n- `/findbiome` -> `/locate biome`\n- `/flyspeed` -> `/attribute Alice minecraft:generic.flying_speed`\n- `/walkspeed` -> `/attribute Alice minecraft:movement_speed`\n- `/maxhealth` -> `/attribute Alice minecraft:generic.max_health`\n- `/groundclean` -> `/kill @e[type=...]`\n- `/spawnmob` -> `/summon`\n- `/shoot` -> `/summon` with motion\n- `/smite` and `/thunder` -> `/summon minecraft:lighting_bolt`\n"), @ColorBox(id=1753243426623L, color=ColorBox.ColorBoxTypes.EXAMPLE, value="\u25c9 Define a `/tpw` command to teleport players to a specified dimension.\nPattern: `tpw resource-world`\nBundle:\n1. `run as fake-op %player:name% tppos --centerX 0 --centerZ 0 --maxRange 128 --dimension fuji:overworld`\n")})
@CommandNode(value="command-bundle")
@CommandRequirement(level=4)
public class CommandBundleInitializer
extends ModuleInitializer {
    public static final BaseConfigurationHandler<CommandBundleConfigModel> config = ObjectConfigurationHandler.ofModule("config.json", CommandBundleConfigModel.class);

    @Document(id=1751826359683L, value="Register all commands defined in bundle-command configuration file.")
    @CommandNode(value="register")
    private static int $registerAllBundleCommands(@CommandSource class_2168 source) {
        if (!CommandBundleInitializer.getRegisteredBundleCommandDescriptors().isEmpty()) {
            TextHelper.sendTextByKey(source, "command_bundle.register.already_registered", new Object[0]);
            return 0;
        }
        LogUtil.info("Register bundle commands.", new Object[0]);
        config.model().getBundleCommands().stream().map(BundleCommandDescriptor.Maker::from).forEach(it -> {
            LogUtil.info("Register bundle command: {}", it.getCommandSyntax());
            it.register();
        });
        CommandHelper.updateCommandTree();
        TextHelper.sendTextByKey(source, "command_bundle.register", new Object[0]);
        return 1;
    }

    @Document(id=1751826362252L, value="Un-register all bundle-commands registered in server.")
    @CommandNode(value="un-register")
    private static int $unregisterAllBundleCommands(@CommandSource class_2168 source) {
        List<CommandDescriptor> registeredBundleCommandDescriptors = CommandBundleInitializer.getRegisteredBundleCommandDescriptors();
        if (registeredBundleCommandDescriptors.isEmpty()) {
            TextHelper.sendTextByKey(source, "command_bundle.un-register.none_registered", new Object[0]);
            return 0;
        }
        LogUtil.info("Un-register bundle commands.", new Object[0]);
        registeredBundleCommandDescriptors.forEach(it -> {
            LogUtil.info("Un-register bundle command: {}", it.getCommandSyntax());
            it.unregister();
        });
        CommandHelper.updateCommandTree();
        TextHelper.sendTextByKey(source, "command_bundle.un-register", new Object[0]);
        return 1;
    }

    @NotNull
    private static List<CommandDescriptor> getRegisteredBundleCommandDescriptors() {
        return CommandAnnotationProcessor.REGISTERED_COMMAND_DESCRIPTORS.stream().filter(it -> it instanceof BundleCommandDescriptor).toList();
    }

    @Document(id=1751826364625L, value="List all registered bundle-commands in server.")
    @CommandNode(value="list")
    private static int $list(@CommandSource CommandContext<class_2168> ctx) {
        return CommandsInspectionGui.inspectCommandDescriptors(ctx, it -> it instanceof BundleCommandDescriptor);
    }

    @EventConsumer
    private static void registerAllBundleCommands(@Unused ServerStartedEvent event) {
        CommandBundleInitializer.$registerAllBundleCommands(CommandHelper.Source.getConsoleCommandSource());
    }

    @EventConsumer
    private static void onCommandRegistrationEvent(@Unused CommandRegistrationEvent event) {
        ServerHelper.withServerInstantiated(() -> CommandBundleInitializer.$registerAllBundleCommands(CommandHelper.Source.getConsoleCommandSource()));
    }

    @Override
    @TestCase(action="Issue `/reload`, `/fuji reload`, `/fuji inspect fuji-commands` and `/command-bundle list`", targets={"The bundle commands should be able to register and un-register on the fly."})
    protected void onReload() {
        CommandBundleInitializer.$unregisterAllBundleCommands(CommandHelper.Source.getConsoleCommandSource());
        CommandBundleInitializer.$registerAllBundleCommands(CommandHelper.Source.getConsoleCommandSource());
    }
}

