/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.command_menu;

import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.command.annotation.CommandNode;
import io.github.sakurawald.fuji.core.command.annotation.CommandRequirement;
import io.github.sakurawald.fuji.core.command.annotation.CommandSource;
import io.github.sakurawald.fuji.core.command.executor.CommandExecutor;
import io.github.sakurawald.fuji.core.command.executor.structure.ExtendedCommandSource;
import io.github.sakurawald.fuji.core.config.handler.abst.BaseConfigurationHandler;
import io.github.sakurawald.fuji.core.config.handler.impl.ObjectConfigurationHandler;
import io.github.sakurawald.fuji.core.document.annotation.ColorBox;
import io.github.sakurawald.fuji.core.document.annotation.ColorBoxes;
import io.github.sakurawald.fuji.core.document.annotation.Document;
import io.github.sakurawald.fuji.core.event.annotation.EventConsumer;
import io.github.sakurawald.fuji.core.event.message.player.PlayerActionEvent;
import io.github.sakurawald.fuji.core.manager.impl.task.GameTaskManager;
import io.github.sakurawald.fuji.module.initializer.ModuleInitializer;
import io.github.sakurawald.fuji.module.initializer.command_menu.command.argument.wrapper.MenuName;
import io.github.sakurawald.fuji.module.initializer.command_menu.config.CommandMenuConfigModel;
import io.github.sakurawald.fuji.module.initializer.command_menu.config.CommandMenuMenusModel;
import io.github.sakurawald.fuji.module.initializer.command_menu.structure.MenuDescriptor;
import net.minecraft.class_2168;
import net.minecraft.class_2846;
import net.minecraft.class_3222;

@Document(id=1751824895470L, value="This module allows you to define `menu` GUI, to execute commands.\n")
@ColorBoxes(value={@ColorBox(id=1752900650332L, color=ColorBox.ColorBoxTypes.NOTE, value="\u25c9 The definition of `menu` and `slot`.\nA `menu` is a virtual `container GUI`.\nThe `virtual GUI` is composed of `slots`.\nA `slot` is used to hold an `item stack`.\nThe `minimal size` of the GUI is `9 x 1 = 9 slots`\nThe `maximal size` of the GUI is `9 x 6 = 54 slots`\n\n<green>In short, you can define a `menu` to hold `slots`.\n<green>And bind `commands` to the `slots`.\n"), @ColorBox(id=1751870445592L, color=ColorBox.ColorBoxTypes.TIP, value="\u25c9 Use the built-in `event`, to open the `GUI`\nThe `command_menu` module provides an event called `onSneakingAndSwapHandsEvent`.\nIt will be triggered when a player press `SHIFT + F` key.\nYou can configure this event in the config file.\n\n\u25c9 Use `command_bundle` to create a command, to open the `GUI`\nThe `/command-menu open` command is an `admin-level` command.\nYou need to use `command_bundle` module, to creat a `user-level` command.\n"), @ColorBox(id=1756687876655L, color=ColorBox.ColorBoxTypes.TIP, value="\u25c9 Switch the `command context` of `command execution`.\nAll commands bound to `slot` are executed `as console`.\nYou may need the `command_meta.run` module, to modify the `command context`.\n- `/run as console \\<cmd\\>`\n- `/run as player %player:name% \\<cmd\\>`\n- `/run as fake-op %player:name% \\<cmd\\>`\n"), @ColorBox(id=1751968513281L, color=ColorBox.ColorBoxTypes.TIP, value="\u25c9 Create a `nested` menus.\nIf you want to create a `nested menu`:\nClick a `slot` in `menu A`, it will opens the `menu B`.\nThen you need to disable the `close_menu_on_clicked` option for `menu A`.\nTo prevent the `menu B` being `opened` and `closed instantly`.\n\n\u25c9 Handle the `menu closing` manually.\nYou can use `/run as fake-op %player:name% command-menu close %player:name%` command.\nTo `close` the `opened GUI` for a `player`.\n"), @ColorBox(id=1753435167488L, color=ColorBox.ColorBoxTypes.TIP, value="\u25c9 Use the `menu editor` online to design a menu easily.\nThanks to <dark_green>Hitnam</dark_green>, we have an `online editor` for `command_menu` module.\nThe tool is hosted in: https://fuji-command-menu-editor-k4k4.vercel.app/\n"), @ColorBox(id=1755690116092L, color=ColorBox.ColorBoxTypes.TIP, value="\u25c9 Use a custom player skull as the slot's icon.\nYou can modify the `item` property for that slot directly.\nThe syntax of `item` is the same as the `/give \\<item\\>` command.\n\n<green>NOTE: The data format may be different across MC versions.\n1. `/give @s minecraft:player_head[minecraft:profile=Steve]`\n2. `/give @s minecraft:player_head{SkullOwner:\"Steve\"}`\n")})
@CommandNode(value="command-menu")
@CommandRequirement(level=4)
public class CommandMenuInitializer
extends ModuleInitializer {
    public static final BaseConfigurationHandler<CommandMenuConfigModel> config = ObjectConfigurationHandler.ofModule("config.json", CommandMenuConfigModel.class);
    public static final BaseConfigurationHandler<CommandMenuMenusModel> menus = ObjectConfigurationHandler.ofModule("menus.json", CommandMenuMenusModel.class);

    @Document(id=1751824900662L, value="Open the specified `menu` for the player.")
    @CommandNode(value="open")
    private static int $open(@CommandSource class_2168 source, class_3222 player, MenuName menuName) {
        String $menuName = (String)menuName.getValue();
        if (!menus.model().getMenus().containsKey($menuName)) {
            TextHelper.getTextByKey(source, "command_menu.menu.not_found", $menuName);
            return 0;
        }
        MenuDescriptor menuDescriptor = menus.model().getMenus().get($menuName);
        GameTaskManager.runInTicks(1, () -> menuDescriptor.build(player).open());
        return 1;
    }

    @Document(id=1751824905935L, value="Close the currently `opened GUI` for the player.")
    @CommandNode(value="close")
    private static int $close(@CommandSource class_2168 source, class_3222 player) {
        CommandMenuInitializer.closeCurrentHandledScreen(player);
        return 1;
    }

    public static void closeCurrentHandledScreen(class_3222 player) {
        player.method_7346();
    }

    public static void executeOnSneakingAndSwapHandsCommands(class_3222 player) {
        CommandExecutor.executeBatch(ExtendedCommandSource.asConsole(player.method_5671()), CommandMenuInitializer.config.model().onSneakingAndSwapHandsEvent.commands);
    }

    @EventConsumer
    private static void consumePlayerActionEvent(PlayerActionEvent event) {
        if (!CommandMenuInitializer.config.model().onSneakingAndSwapHandsEvent.enable) {
            return;
        }
        class_2846 packet = event.getPacket();
        class_3222 player = event.getPlayer();
        if (packet.method_12363() == class_2846.class_2847.field_12969 && player.method_5715()) {
            CommandMenuInitializer.executeOnSneakingAndSwapHandsCommands(player);
            event.getCallbackInfo().cancel();
        }
    }
}

