/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.command_menu.structure;

import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import eu.pb4.sgui.api.gui.SlotGuiInterface;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.GuiHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.command.executor.CommandExecutor;
import io.github.sakurawald.fuji.core.command.executor.structure.ExtendedCommandSource;
import io.github.sakurawald.fuji.core.document.annotation.Document;
import io.github.sakurawald.fuji.module.initializer.command_menu.structure.SlotDescriptor;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import net.minecraft.class_3222;
import net.minecraft.class_3917;

public class MenuDescriptor {
    @Document(id=1751824832095L, value="The `title` of this GUI.\n")
    public String title;
    @Document(id=1751824836843L, value="Ranged [1, 6]\n")
    public int lines;
    @Document(id=1751824840934L, value="Should we `close` this GUI automatically when any `slot` is `clicked`?\n\nOr you need to execute `/command-menu close <player>` command.\nTo close the GUI manually.\n")
    public boolean closeMenuOnClicked;
    public Commands commands;
    @Document(id=1751824845545L, value="Defined `slots` for this GUI.\n")
    public List<SlotDescriptor> slots;

    private class_3917<?> getScreenHandlerType() {
        return GuiHelper.Handler.getGenericContainerType(this.lines);
    }

    public SimpleGui build(final class_3222 viewingPlayer) {
        SimpleGui menuGui = new SimpleGui(this.getScreenHandlerType(), viewingPlayer, false){

            public void onOpen() {
                super.onOpen();
                CommandExecutor.executeBatch(ExtendedCommandSource.asConsole(viewingPlayer.method_5671()), MenuDescriptor.this.commands.on_open_commands);
            }

            public void onClose() {
                super.onClose();
                CommandExecutor.executeBatch(ExtendedCommandSource.asConsole(viewingPlayer.method_5671()), MenuDescriptor.this.commands.on_closed_commands);
            }
        };
        menuGui.setTitle(TextHelper.getTextByValue(viewingPlayer, this.title, new Object[0]));
        AtomicReference blankSlotsFiller = new AtomicReference();
        this.slots.forEach(slotDescriptor -> {
            if (slotDescriptor.canViewThisSlot(viewingPlayer)) {
                GuiElementInterface element = slotDescriptor.buildGuiElement(viewingPlayer, this);
                menuGui.setSlot(slotDescriptor.getIndex(), element);
                slotDescriptor.getOtherIndexes().forEach(otherIndex -> menuGui.setSlot(otherIndex.intValue(), element));
                if (slotDescriptor.isFillBlankIndexes()) {
                    blankSlotsFiller.set(slotDescriptor);
                }
            }
        });
        if (blankSlotsFiller.get() != null) {
            GuiElementInterface element = ((SlotDescriptor)blankSlotsFiller.get()).buildGuiElement(viewingPlayer, this);
            GuiHelper.Placer.fillEmptySlots((SlotGuiInterface)menuGui, element);
        }
        return menuGui;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public int getLines() {
        return this.lines;
    }

    @Generated
    public boolean isCloseMenuOnClicked() {
        return this.closeMenuOnClicked;
    }

    @Generated
    public Commands getCommands() {
        return this.commands;
    }

    @Generated
    public List<SlotDescriptor> getSlots() {
        return this.slots;
    }

    @Generated
    public MenuDescriptor setTitle(String title) {
        this.title = title;
        return this;
    }

    @Generated
    public MenuDescriptor setLines(int lines) {
        this.lines = lines;
        return this;
    }

    @Generated
    public MenuDescriptor setCloseMenuOnClicked(boolean closeMenuOnClicked) {
        this.closeMenuOnClicked = closeMenuOnClicked;
        return this;
    }

    @Generated
    public MenuDescriptor setCommands(Commands commands) {
        this.commands = commands;
        return this;
    }

    @Generated
    public MenuDescriptor setSlots(List<SlotDescriptor> slots) {
        this.slots = slots;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MenuDescriptor)) {
            return false;
        }
        MenuDescriptor other = (MenuDescriptor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getLines() != other.getLines()) {
            return false;
        }
        if (this.isCloseMenuOnClicked() != other.isCloseMenuOnClicked()) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        Commands this$commands = this.getCommands();
        Commands other$commands = other.getCommands();
        if (this$commands == null ? other$commands != null : !this$commands.equals(other$commands)) {
            return false;
        }
        List<SlotDescriptor> this$slots = this.getSlots();
        List<SlotDescriptor> other$slots = other.getSlots();
        return !(this$slots == null ? other$slots != null : !((Object)this$slots).equals(other$slots));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MenuDescriptor;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getLines();
        result = result * 59 + (this.isCloseMenuOnClicked() ? 79 : 97);
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        Commands $commands = this.getCommands();
        result = result * 59 + ($commands == null ? 43 : $commands.hashCode());
        List<SlotDescriptor> $slots = this.getSlots();
        result = result * 59 + ($slots == null ? 43 : ((Object)$slots).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MenuDescriptor(title=" + this.getTitle() + ", lines=" + this.getLines() + ", closeMenuOnClicked=" + this.isCloseMenuOnClicked() + ", commands=" + String.valueOf(this.getCommands()) + ", slots=" + String.valueOf(this.getSlots()) + ")";
    }

    @Generated
    public MenuDescriptor() {
    }

    public static class Commands {
        public List<String> on_open_commands = new ArrayList<String>();
        public List<String> on_closed_commands = new ArrayList<String>();
    }
}

