/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.command_meta.IF;

import io.github.sakurawald.fuji.core.auxiliary.LogUtil;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.CommandHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.command.annotation.CommandNode;
import io.github.sakurawald.fuji.core.command.annotation.CommandRequirement;
import io.github.sakurawald.fuji.core.command.annotation.CommandSource;
import io.github.sakurawald.fuji.core.command.argument.wrapper.impl.GreedyString;
import io.github.sakurawald.fuji.core.command.exception.AbortCommandExecutionException;
import io.github.sakurawald.fuji.core.command.executor.CommandExecutor;
import io.github.sakurawald.fuji.core.command.executor.structure.ExtendedCommandSource;
import io.github.sakurawald.fuji.core.document.annotation.ColorBox;
import io.github.sakurawald.fuji.core.document.annotation.ColorBoxes;
import io.github.sakurawald.fuji.core.document.annotation.Document;
import io.github.sakurawald.fuji.core.document.annotation.TestCase;
import io.github.sakurawald.fuji.module.initializer.ModuleInitializer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_2168;
import org.apache.logging.log4j.util.TriConsumer;

@Document(id=1753515891751L, value="This module provides a simple `/IF` command.\nIt can be used to express `conditional logic`, such as `IF ... THEN ... ELSE ...`.\n")
@ColorBoxes(value={@ColorBox(id=1753515940860L, color=ColorBox.ColorBoxTypes.NOTE, value="\u25c9 How it works?\nThe syntax of `/IF` command is: `/IF \\<condition-command\\> THEN \\<then-command\\> ELSE \\<else-command\\>`\n<red>The `IF`, `THEN`, `ELSE` literals must be `capitalized`.\n\nThe execution flow of this command is as follows:\n1. Start the `execution` of a given `/IF` command instance.\n2. Check the possible `ambiguity` of the given `/IF` command instance.\n2.a. If `no ambiguity` found, goto step `3.`\n2.b. If there is `an ambiguity` found, abort the entire execution of `/IF` command.\n3. Execute the `condition-command`, and get its `return value`:\n3.a. If `the return value` is `true`, then `executes` the `then-command`.\n3.b. If `the return value` is `false`, then `executes` the `else-command`.\n\n\u25c9 Any `failure` will lead to the execution of `else-command`.\n<red>If there is any `error` during the `execution` of `condition-command`, the `else-command` will be executed.\nFor example, the `/IF bad command THEN say true ELSE say false` command will do the following things:\n1. First, execute the `/bad command`.\n2. Due to the `error` during the execution of `/bad command`, the `/say false` command will be executed.\n\n\u25c9 `Recursive IF` is not supported.\nThe `/IF` command is a `simple` enough command, to provide a very basic `conditional expression`.\nThe `nested IF` is not supported.\nOnce there is an `ambiguity` found in the `/IF` command, the entire execution of the `/IF` command will be aborted.\n"), @ColorBox(id=1753596414690L, color=ColorBox.ColorBoxTypes.NOTE, value="\u25c9 The difference between `/IF` command and `/execute if` command.\nThe `/execute if` command is a powerful command:\n1. You can use `recursive if`.\nFor example: `/execute if \\<first-condition\\> if \\<second-condition\\>`\n2. You can use lots of `built-in Minecraft predicates`.\nFor example: `/execute if {block|biome|loaded|dimension|score|blocks|entity|predicate|function|items|data}`\n3. You can `simulate` the `else-clause` by combining the `/execute if` and `/execute unless` commands.\n\n\u25c9 What is the `purpose` of `/IF` command?\n1. It allows you to use `any command` as the `condition`, based on the `return value` of that command.\n2. It prevents the `side-effect` from the `condition-clause` and `then-command`. (Without the `/tag` or `/scoreboard`)\n3. It provides a simple and in-line way to express the `IF ... THEN ... ELSE ...` logic.\n4. It supports the `placeholders`.\n5. Still, You can leverage the `/execute if` command as the `condition-command` of `/IF` command.\n"), @ColorBox(id=1753594904128L, color=ColorBox.ColorBoxTypes.TIP, value="\u25c9 Useful commands.\n1. https://minecraft.fandom.com/wiki/Commands/execute\n2. https://minecraft.wiki/w/Commands/return\n3. https://minecraft.fandom.com/wiki/Commands/scoreboard\n4. https://minecraft.fandom.com/wiki/Commands/tag\n5. https://minecraft.fandom.com/wiki/Commands/data\n"), @ColorBox(id=1753668342721L, color=ColorBox.ColorBoxTypes.TIP, value="\u25c9 Write the `IF ... THEN ... ELSE ...` logic conveniently.\nYou can use `command_bundle` module to create a `template command` to help you write `conditional logic`.\nFor example, you can create a new command `/try-give-item <item> <required-balance>`.\n"), @ColorBox(id=1753521193815L, color=ColorBox.ColorBoxTypes.EXAMPLE, value="\u25c9 Check whether a player is an `operator`.\nIssue: `/IF is-op? %player:name% THEN say It is op. ELSE say It is not op.`\n\n\u25c9 Check whether a player has sufficient balance.\nIssue: `/IF has-currency? %player:name% fuji:gold 100 THEN say Sufficient balance. ELSE say Insufficient balance.`\n\n\u25c9 Use a shorten version of `/IF ... THEN ...` command.\nThe `/nop` command `performs no action` and always `returns success`.\nYou can use it as a `dummy command` in the `else-command` place, to effectively ignore it.\nIssue: `/IF is-op? %player:name% THEN say It is op. ELSE nop`\n\n\u25c9 Specify `multiple commands` in one place, by using the `/chain` command.\nIssue: `/IF is-op? %player:name% THEN chain say It is op. chain say Hello op! ELSE nop`\n\n\u25c9 Leverage the power of `/execute if`. (And the `/execute unless` command)\nIssue: `/IF execute if block ~ ~-1 ~ minecraft:diamond_block THEN say You are standing on diamond block. ELSE say You are not standing on diamond block.`\n\n\u25c9 Combine 2 conditions using `chained if`, and only execute the `then-command` when they are all `true`.\nIssue: `/IF execute if block ~ ~-1 ~ minecraft:diamond_block if entity @s[nbt={Inventory:[{id:\"minecraft:diamond\"}]}] THEN say All true. ELSE say Not all true.`\nThe `then-command` will only be executed if the `condition-command` is `true`:\n1. The player is standing on a `minecraft:diamond_block` block.\n2. The player has a `minecraft:diamond` item in its inventory.\n"), @ColorBox(id=1756263469899L, color=ColorBox.ColorBoxTypes.EXAMPLE, value="\u25c9 Filter all the online players by a predicate\nYou can integrate `/IF` with the `/foreach` command.\n1. `/foreach IF \\<predicate-command\\> THEN ... ELSE ...`\n2. `/foreach IF has-item? %player:name% minecraft:apple 1 THEN say Player %player:name% has an apple. ELSE nop`\n3. `/foreach IF is-in-world? %player:name% minecraft:overworld THEN say Player %player:name% is in overworld. ELSE nop`\n\n\u25c9 Leverage the vanilla Minecraft's `/tag` command, to store states.\nExample:\n1. `/tag Steve add killed_the_dragon`\n2. `/execute if entity @a[tag=killed_the_dragon]`\n\n\u25c9 Leverage the vanilla Minecraft's `/scoreboard` command, to store states.\nIt's similar to `/tag` command, but more advanced.\n"), @ColorBox(id=1753592396075L, color=ColorBox.ColorBoxTypes.NOTE, value="\u25c9 Use `/command-debug` command to see the `return value` of a command.\nThe `return value` is not displayed explicitly in-game.\nHowever, you can use `/command-debug` command to see `the return value` of a specified command.\nIssue:\n1. `/command-debug execute if block ~ ~-1 ~ minecraft:diamond_block`\n2. `/command-debug execute if block ~ ~-1 ~ minecraft:diamond_block if entity @s[nbt={Inventory:[{id:\"minecraft:diamond\"}]}]`\n\n\u25c9 The behaviour of `/execute if` command.\n1. When `none condition` is `true`, it throws a `Test failed` exception.\n2. When `one of the specified conditions` is `true`, it will returns `0` to mean `partial success`.\n3. When `all of the specified conditions` are `true`, it will returns `a positive integer` to mean `success`.\nNOTE: This `positive integer` equals to `the number of successful branch` if the `/execute if` command is `forked`.\n\nFor example, if you have `3` players online, but only `2` of them are standing on a `minecraft:diamond_block` block.\nIssue: `/command-debug execute at @a if block ~ ~-1 ~ minecraft:diamond_block`\nYou will get the integer `2` as the `return value` of that `/execute ...` command instance.\n")})
public class IfInitializer
extends ModuleInitializer {
    @TestCase(action="Issue `/IF execute if block ~ ~-1 ~ minecraft:diamond_block THEN say You are standing on diamond block. ELSE say You are not standing on diamond block.` command.", targets={"You should not see the red `Test failed` in the feedback."})
    private static final String CONDITIONAL_FAIL_EXCEPTION_PREFIX_STRING = "Test failed";
    private static final Pattern IF_COMMAND_PARSER = Pattern.compile("(.+)\\s+THEN\\s+(.+)\\s+ELSE\\s+(.+)");
    private static final String THEN_LITERAL = "THEN";
    private static final String ELSE_LITERAL = "ELSE";

    private static void checkAmbiguity(class_2168 source, String conditionCommand, String thenCommand, String elseCommand) {
        if (conditionCommand.contains(THEN_LITERAL) || conditionCommand.contains(ELSE_LITERAL)) {
            TextHelper.sendTextByKey(source, "if.matcher.ambiguity", new Object[0]);
            throw new AbortCommandExecutionException();
        }
        if (thenCommand.contains(THEN_LITERAL) || thenCommand.contains(ELSE_LITERAL)) {
            TextHelper.sendTextByKey(source, "if.matcher.ambiguity", new Object[0]);
            throw new AbortCommandExecutionException();
        }
        if (elseCommand.contains(THEN_LITERAL) || elseCommand.contains(ELSE_LITERAL)) {
            TextHelper.sendTextByKey(source, "if.matcher.ambiguity", new Object[0]);
            throw new AbortCommandExecutionException();
        }
    }

    @CommandNode(value="IF")
    @CommandRequirement(level=4)
    private static int $if(@CommandSource class_2168 source, GreedyString rest) {
        String $rest = (String)rest.getValue();
        Matcher matcher = IF_COMMAND_PARSER.matcher($rest);
        if (matcher.find()) {
            String conditionCommand = matcher.group(1);
            String thenCommand = matcher.group(2);
            String elseCommand = matcher.group(3);
            IfInitializer.checkAmbiguity(source, conditionCommand, thenCommand, elseCommand);
            LogUtil.debug("Execute an `/IF` command: condition-command = {}, then-command = {}, else-command = {}", conditionCommand, thenCommand, elseCommand);
            int conditionValue = CommandExecutor.executeSingle(ExtendedCommandSource.fromSource(source), conditionCommand, (TriConsumer<ExtendedCommandSource, String, Exception>)((TriConsumer)IfInitializer::handleIfCommandException));
            if (CommandHelper.Return.isSuccess(conditionValue)) {
                CommandExecutor.executeSingle(ExtendedCommandSource.fromSource(source), thenCommand, (TriConsumer<ExtendedCommandSource, String, Exception>)((TriConsumer)IfInitializer::handleIfCommandException));
            } else {
                CommandExecutor.executeSingle(ExtendedCommandSource.fromSource(source), elseCommand, (TriConsumer<ExtendedCommandSource, String, Exception>)((TriConsumer)IfInitializer::handleIfCommandException));
            }
        } else {
            TextHelper.sendTextByKey(source, "if.matcher.failed", new Object[0]);
            return 0;
        }
        return 1;
    }

    private static void handleIfCommandException(ExtendedCommandSource context, String commandString, Exception exception) {
        String message = exception.getMessage();
        if (message.startsWith(CONDITIONAL_FAIL_EXCEPTION_PREFIX_STRING)) {
            LogUtil.debug("Swallow the exception with message: {}", message);
            return;
        }
        CommandExecutor.handleCommandExecutorException(context, commandString, exception);
    }
}

