/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.command_meta.delay;

import io.github.sakurawald.fuji.core.annotation.Unused;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.ServerHelper;
import io.github.sakurawald.fuji.core.command.annotation.CommandNode;
import io.github.sakurawald.fuji.core.command.annotation.CommandRequirement;
import io.github.sakurawald.fuji.core.command.annotation.CommandSource;
import io.github.sakurawald.fuji.core.command.argument.wrapper.impl.GreedyString;
import io.github.sakurawald.fuji.core.command.executor.CommandExecutor;
import io.github.sakurawald.fuji.core.command.executor.structure.ExtendedCommandSource;
import io.github.sakurawald.fuji.core.document.annotation.ColorBox;
import io.github.sakurawald.fuji.core.document.annotation.ColorBoxes;
import io.github.sakurawald.fuji.core.document.annotation.Document;
import io.github.sakurawald.fuji.core.event.annotation.EventConsumer;
import io.github.sakurawald.fuji.core.event.message.server.lifecycle.ServerStartedEvent;
import io.github.sakurawald.fuji.core.event.message.server.lifecycle.ServerStoppingEvent;
import io.github.sakurawald.fuji.module.initializer.ModuleInitializer;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_2168;

@Document(id=1751969384267L, value="This module provides the `/delay` command.\nTo allow you `delay` the `execution time` of a specified command.\n")
@ColorBoxes(value={@ColorBox(id=1751870419626L, color=ColorBox.ColorBoxTypes.NOTE, value="\u25c9 Only use `/delay` to perform short-term job.\nThe `delayed commands` will not be persisted, if the server get a re-start.\n"), @ColorBox(id=1751969752045L, color=ColorBox.ColorBoxTypes.EXAMPLE, value="\u25c9 A basic usage.\nIssue: `/delay 3 say three seconds passed`\n\n\u25c9 A nested delay.\nIssue: `/delay 1 delay 2 delay 3 say 6 seconds passed`\n\n\u25c9 A fine-grained delay.\nIssue: `/delay 3.1415926 say pi seconds passed`\n")})
public class DelayInitializer
extends ModuleInitializer {
    private static ScheduledExecutorService DELAY_COMMAND_EXECUTOR;

    @Document(id=1751824706971L, value="Execute a command in seconds.")
    @CommandNode(value="delay")
    @CommandRequirement(level=4)
    private static int $delay(@CommandSource class_2168 source, double time, GreedyString rest) {
        String $rest = (String)rest.getValue();
        long scheduleTimeMs = (long)(1000.0 * time);
        ScheduledFuture<?> unused = DELAY_COMMAND_EXECUTOR.schedule(() -> ServerHelper.executeSync(() -> CommandExecutor.executeSingle(ExtendedCommandSource.asConsole(source), $rest)), scheduleTimeMs, TimeUnit.MILLISECONDS);
        return 1;
    }

    @EventConsumer
    private static void resetDelaySchedulerExecutor(@Unused ServerStartedEvent event) {
        DELAY_COMMAND_EXECUTOR = Executors.newSingleThreadScheduledExecutor();
    }

    @EventConsumer
    private static void shutdownDelaySchedulerExecutor(@Unused ServerStoppingEvent event) {
        if (DELAY_COMMAND_EXECUTOR != null) {
            DELAY_COMMAND_EXECUTOR.shutdown();
        }
    }
}

