/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.command_meta.when_online.gui;

import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import io.github.sakurawald.fuji.core.auxiliary.ChronosUtil;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.GuiHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.gui.component.gui.ConfirmSignGui;
import io.github.sakurawald.fuji.core.gui.component.gui.PagedGui;
import io.github.sakurawald.fuji.module.initializer.command_meta.when_online.WhenOnlineInitializer;
import io.github.sakurawald.fuji.module.initializer.command_meta.when_online.structure.WhenOnlineTicket;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ListWhenOnlineTicketsGui
extends PagedGui<WhenOnlineTicket> {
    public ListWhenOnlineTicketsGui(@Nullable SimpleGui parent, @NotNull class_3222 player, @NotNull List<WhenOnlineTicket> entities, int pageIndex) {
        super(parent, player, TextHelper.getTextByKey(player, "command_meta.when_online.gui.title", new Object[0]), entities, pageIndex);
    }

    @Override
    protected PagedGui<WhenOnlineTicket> makePage(@Nullable SimpleGui parent, @NotNull class_3222 player, class_2561 title, @NotNull List<WhenOnlineTicket> entities, int pageIndex) {
        return new ListWhenOnlineTicketsGui(parent, player, entities, pageIndex);
    }

    public static ListWhenOnlineTicketsGui make(class_3222 player) {
        List<WhenOnlineTicket> tickets = WhenOnlineInitializer.data.model().tickets.stream().sorted(Comparator.comparing(WhenOnlineTicket::isExecuted).thenComparing(WhenOnlineTicket::getCreatedTimestamp)).toList();
        return new ListWhenOnlineTicketsGui(null, player, tickets, 0);
    }

    @Override
    @NotNull
    protected GuiElementInterface toGuiElement(@NotNull WhenOnlineTicket entity) {
        GuiElementBuilder builder = new GuiElementBuilder();
        ArrayList<class_2561> lore = new ArrayList<class_2561>();
        lore.add(TextHelper.getTextByKey(this.getPlayer(), "entity.created_timestamp", ChronosUtil.Formatter.formatDate(entity.createdTimestamp)));
        lore.add(TextHelper.getTextByKey(this.getPlayer(), "entity.creator_name", entity.creatorName));
        lore.add(TextHelper.getTextByKey(this.getPlayer(), "player.target_player.name", entity.getTargetPlayer()));
        lore.add(TextHelper.getTextByKey(this.getPlayer(), "command", TextHelper.Parsers.escapeTags(entity.command)));
        lore.add(TextHelper.getTextByKey(this.getPlayer(), "entity.executed_timestamp", ChronosUtil.Formatter.formatDate(entity.executedTimestamp)));
        lore.add(TextHelper.getTextByKey(this.getPlayer(), "prompt.click.delete.right_click", new Object[0]));
        class_1792 item = GuiHelper.Material.fromBooleanValue(entity.isExecuted());
        builder.setItem(item).setName(TextHelper.getTextByKey(this.getPlayer(), "command_meta.when_online.gui.name", new Object[0])).setLore(lore).setCallback(ListWhenOnlineTicketsGui.onClickEntity(this.getBackendGui(), this.getPlayer(), entity));
        return builder.build();
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull GuiElementInterface.ItemClickCallback onClickEntity(final SimpleGui gui, class_3222 player, final WhenOnlineTicket entity) {
        return (a, b, c) -> {
            if (b.isRight) {
                new ConfirmSignGui(player){

                    @Override
                    public void onConfirm() {
                        WhenOnlineInitializer.data.model().tickets.remove(entity);
                        WhenOnlineInitializer.data.writeStorage();
                        ListWhenOnlineTicketsGui.make(this.player).open();
                    }

                    @Override
                    protected void onCancelled() {
                        gui.open();
                    }
                }.open();
            }
        };
    }
}

