/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.command_permission.gui;

import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import eu.pb4.sgui.api.gui.SlotGuiInterface;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.GuiHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.gui.component.gui.PagedGui;
import io.github.sakurawald.fuji.module.initializer.command_permission.CommandPermissionInitializer;
import io.github.sakurawald.fuji.module.initializer.command_permission.service.CommandPermissionService;
import io.github.sakurawald.fuji.module.initializer.command_permission.structure.CommandNodePermissionWrapper;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommandPermissionGui
extends PagedGui<CommandNodePermissionWrapper> {
    public CommandPermissionGui(class_3222 player, @NotNull List<CommandNodePermissionWrapper> entities, int pageIndex) {
        super(null, player, TextHelper.getTextByKey(player, "command_permission.list.gui.title", new Object[0]), entities, pageIndex);
        GuiHelper.Placer.setSlotInLastLine((SlotGuiInterface)this, 4, GuiHelper.Button.makeHelpButton(player).setLore(TextHelper.getTextListByKey(player, "command_permission.list.gui.help.lore")));
    }

    @Override
    protected PagedGui<CommandNodePermissionWrapper> makePage(@Nullable SimpleGui parent, @NotNull class_3222 player, class_2561 title, @NotNull List<CommandNodePermissionWrapper> entities, int pageIndex) {
        return new CommandPermissionGui(player, entities, pageIndex);
    }

    @Override
    @NotNull
    protected GuiElementInterface toGuiElement(@NotNull CommandNodePermissionWrapper entity) {
        boolean commandNodeWrapped = CommandPermissionService.isCommandNodeWrapped(entity.getNode());
        return new GuiElementBuilder().setItem(GuiHelper.Material.fromBooleanValue(commandNodeWrapped)).setName((class_2561)class_2561.method_43470((String)entity.getPath())).setCallback((index, clickType, actionType) -> {
            String commandPathString = entity.getPath();
            String commandPermissionString = CommandPermissionInitializer.COMMAND_PERMISSION_UNIFIED_PERMISSION.withArguments(commandPathString);
            if (clickType.isLeft) {
                String executionCommand = "/lp group default permission set %s true".formatted(commandPermissionString);
                TextHelper.sendTextByKey(this.getPlayer(), "command_permission.command.set_true", commandPathString, executionCommand, executionCommand);
            } else if (clickType.isRight) {
                String executionCommand = "/lp group default permission set %s false".formatted(commandPermissionString);
                TextHelper.sendTextByKey(this.getPlayer(), "command_permission.command.set_false", commandPathString, executionCommand, executionCommand);
            } else if (clickType.isMiddle) {
                String executionCommand = "/lp group default permission unset %s".formatted(commandPermissionString);
                TextHelper.sendTextByKey(this.getPlayer(), "command_permission.command.unset", commandPathString, executionCommand, executionCommand);
            }
            this.close();
        }).setLore(List.of(TextHelper.getTextByKey(this.getPlayer(), "command_permission.list.gui.entry.lore", commandNodeWrapped))).build();
    }
}

