/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.command_toolbox.compass;

import io.github.sakurawald.fuji.core.auxiliary.minecraft.EntityHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.ItemStackHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.RegistryHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.command.annotation.CommandNode;
import io.github.sakurawald.fuji.core.command.annotation.CommandSource;
import io.github.sakurawald.fuji.core.command.annotation.CommandTarget;
import io.github.sakurawald.fuji.core.command.argument.wrapper.impl.Dimension;
import io.github.sakurawald.fuji.core.document.annotation.Document;
import io.github.sakurawald.fuji.module.initializer.ModuleInitializer;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

@Document(id=1751825174228L, value="Allow you to set the target point of a compass item.\n")
@CommandNode(value="compass")
public class CompassInitializer
extends ModuleInitializer {
    private static int withCompassInHand(class_3222 source, Function<class_1799, Integer> function) {
        class_1799 itemStack = source.method_6047();
        if (!itemStack.method_7909().equals(class_1802.field_8251)) {
            TextHelper.sendTextByKey(source, "compass.no_compass", new Object[0]);
            return 0;
        }
        return function.apply(itemStack);
    }

    private static void setTrackedTarget(class_1799 itemStack, @Nullable class_3218 world, @Nullable class_2338 blockPos) {
        ItemStackHelper.CustomData.withCustomDataNbt(itemStack, tag -> {
            if (world == null) {
                tag.method_10551("LodestoneTracked");
                tag.method_10551("LodestoneDimension");
            } else {
                tag.method_10556("LodestoneTracked", false);
                tag.method_10582("LodestoneDimension", RegistryHelper.getIdAsString((class_1937)world));
            }
            if (blockPos == null) {
                tag.method_10551("LodestoneTracked");
                tag.method_10551("LodestonePos");
            } else {
                tag.method_10556("LodestoneTracked", false);
                class_2487 posTag = new class_2487();
                posTag.method_10569("X", blockPos.method_10263());
                posTag.method_10569("Y", blockPos.method_10264());
                posTag.method_10569("Z", blockPos.method_10260());
                tag.method_10566("LodestonePos", (class_2520)posTag);
            }
        });
    }

    @Document(id=1751825179946L, value="Let the compass in hand track a specified position.")
    @CommandNode(value="track pos")
    private static int $track(@CommandSource @CommandTarget class_3222 player, Dimension dimension, class_2338 blockPos) {
        return CompassInitializer.withCompassInHand(player, itemStack -> {
            CompassInitializer.setTrackedTarget(itemStack, (class_3218)dimension.getValue(), blockPos);
            return 1;
        });
    }

    @Document(id=1751825185305L, value="Let the compass in hand track a specified player.")
    @CommandNode(value="track player")
    private static int $track(@CommandSource @CommandTarget class_3222 player, class_3222 target) {
        return CompassInitializer.withCompassInHand(player, itemStack -> {
            CompassInitializer.setTrackedTarget(itemStack, EntityHelper.getServerWorld((class_1297)target), target.method_24515());
            return 1;
        });
    }

    @Document(id=1751825191491L, value="Let the compass in hand track nothing.")
    @CommandNode(value="reset")
    private static int $reset(@CommandSource @CommandTarget class_3222 player) {
        return CompassInitializer.withCompassInHand(player, itemStack -> {
            CompassInitializer.setTrackedTarget(itemStack, null, null);
            return 1;
        });
    }
}

