/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.deathlog.gui;

import eu.pb4.sgui.api.elements.GuiElement;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import io.github.sakurawald.fuji.core.auxiliary.LogUtil;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.GuiHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.InventoryHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.PlayerHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.service.display.gui.InventoryDisplayGuiFactory;
import io.github.sakurawald.fuji.module.initializer.deathlog.structure.DeathNode;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

public class DeathNodeDisplayGuiFactory
extends InventoryDisplayGuiFactory {
    private final DeathNode deathNode;

    public DeathNodeDisplayGuiFactory(@NotNull SimpleGui parent, DeathNode deathNode) {
        super(parent, TextHelper.getTextByKey(parent.getPlayer(), "deathlog.death_node.view.gui.title", new Object[0]), deathNode.main, deathNode.armor, deathNode.offhand);
        this.deathNode = deathNode;
    }

    @Override
    @NotNull
    public SimpleGui build(class_3222 viewingPlayer) {
        SimpleGui displayGui = super.build(viewingPlayer);
        GuiElement backButton = ((GuiElementBuilder)GuiHelper.Button.makeBackButton(viewingPlayer).setCallback(() -> displayGui.close())).build();
        displayGui.setSlot(9, (GuiElementInterface)backButton);
        GuiElement restoreButton = ((GuiElementBuilder)new GuiElementBuilder().setItem(class_1802.field_8777).setName(TextHelper.getTextByKey(viewingPlayer, "deathlog.restore.item.name", new Object[0])).setLore(this.deathNode.getLore(viewingPlayer)).setCallback(() -> this.handleRestoreButton(viewingPlayer))).build();
        displayGui.setSlot(17, (GuiElementInterface)restoreButton);
        this.checkIfCurrentNbtFormatSupported(displayGui);
        return displayGui;
    }

    private void checkIfCurrentNbtFormatSupported(SimpleGui displayGui) {
        boolean notSupported;
        boolean bl = notSupported = this.main.stream().allMatch(class_1799::method_7960) && this.armor.stream().allMatch(class_1799::method_7960) && this.offhand.stream().allMatch(class_1799::method_7960);
        if (notSupported) {
            GuiElement errorNotification = new GuiElementBuilder(class_1802.field_8077).setName(TextHelper.getTextByKey(displayGui.getPlayer(), "deathlog.death_node.not_supported_nbt_format", new Object[0])).build();
            for (int i = 0; i < 54; ++i) {
                GuiElementInterface slot = displayGui.getSlot(i);
                if (slot == null || !slot.getItemStack().method_7960()) continue;
                displayGui.setSlot(i, (GuiElementInterface)errorNotification);
            }
        }
    }

    private void handleRestoreButton(class_3222 viewingPlayer) {
        if (!viewingPlayer.method_31548().method_5442()) {
            TextHelper.sendTextByKey(viewingPlayer, "deathlog.restore.target_player.inventory_not_empty", PlayerHelper.getPlayerName((class_1657)viewingPlayer));
            return;
        }
        LogUtil.debug("Restore the death node {} for target player {}", this.deathNode, PlayerHelper.getPlayerName((class_1657)viewingPlayer));
        for (int i = 0; i < this.main.size(); ++i) {
            InventoryHelper.getMainStacks((class_1657)viewingPlayer).set(i, (Object)this.deathNode.main.get(i));
        }
        InventoryHelper.setArmorStacks((class_1657)viewingPlayer, this.deathNode.armor);
        InventoryHelper.setOffhandStacks((class_1657)viewingPlayer, this.deathNode.offhand);
        viewingPlayer.method_7320(this.deathNode.score);
        viewingPlayer.field_7520 = this.deathNode.expLevel;
        viewingPlayer.field_7510 = this.deathNode.expProgress;
        TextHelper.sendTextByKey(viewingPlayer, "deathlog.restore.success", new Object[0]);
    }
}

