/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.document.builder;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import io.github.sakurawald.fuji.core.config.handler.abst.BaseConfigurationHandler;
import io.github.sakurawald.fuji.core.config.mapper.GsonMapper;
import io.github.sakurawald.fuji.core.document.auxiliary.DocumentUtil;
import io.github.sakurawald.fuji.module.initializer.document.builder.DocumentBuilder;
import io.github.sakurawald.fuji.module.initializer.document.builder.DocumentBuilderContext;
import io.github.sakurawald.fuji.module.initializer.document.compiler.DocumentCompiler;
import io.github.sakurawald.fuji.module.initializer.document.config.adapter.DocumentedTypeAdapterFactory;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public class ModuleConfigurationsDocumentBuilder
extends DocumentBuilder {
    private static final AtomicReference<Object> documentGson = new AtomicReference();

    @Override
    public void build(@NotNull DocumentBuilderContext documentBuilderContext) {
        List<BaseConfigurationHandler> moduleConfigurationHandlers = DocumentUtil.getObjectConfigurationHandlers().stream().filter(it -> it.getSourceModule().equals(documentBuilderContext.getModulePathString())).toList();
        if (!moduleConfigurationHandlers.isEmpty()) {
            documentBuilderContext.getDocumentBuilder().append("## Configurations").append(System.lineSeparator());
            documentBuilderContext.getDocumentBuilder().append(":::warning\nThe JSON content is provided for documentation purposes only.\n\nIt should not be copied directly into your configuration folder, as the document format is not valid JSON syntax.\n:::\n");
            moduleConfigurationHandlers.forEach(it -> this.build(documentBuilderContext, (BaseConfigurationHandler<?>)it));
        }
    }

    public void build(@NotNull DocumentBuilderContext documentBuilderContext, @NotNull BaseConfigurationHandler<?> baseConfigurationHandler) {
        String configFileName = baseConfigurationHandler.getFilePath().getFileName().toString();
        String configFilePath = baseConfigurationHandler.computeRelativePathBasedOnGameDir();
        documentBuilderContext.getDocumentBuilder().append(":::config").append(System.lineSeparator()).append("- File Name: `%s`".formatted(configFileName)).append(System.lineSeparator());
        Class<?> configModelClass = baseConfigurationHandler.model().getClass();
        DocumentUtil.getClassDocumentString(null, configModelClass).ifPresent(configModelClassDocumentString -> {
            configModelClassDocumentString = DocumentCompiler.compile(configModelClassDocumentString);
            configModelClassDocumentString = DocumentUtil.duplicateLineSeparatorCharacter(configModelClassDocumentString);
            documentBuilderContext.getDocumentBuilder().append("- Document: %s".formatted(configModelClassDocumentString));
        });
        String jsonString = ModuleConfigurationsDocumentBuilder.getDocumentGson().toJson(baseConfigurationHandler.getDefaultModel());
        documentBuilderContext.getDocumentBuilder().append("- File Content: ").append(System.lineSeparator()).append("<details>\n\n<summary>Click to expand...</summary>\n").append(System.lineSeparator()).append("```json showLineNumbers title=\"%s\"".formatted(configFilePath)).append(System.lineSeparator()).append("%s".formatted(jsonString)).append(System.lineSeparator()).append("```").append(System.lineSeparator()).append("</details>").append(System.lineSeparator());
        documentBuilderContext.getDocumentBuilder().append(":::").append(System.lineSeparator());
    }

    @NotNull
    private static Gson makeDocumentGson() {
        GsonBuilder gsonBuilder = GsonMapper.__GetInternalGsonReferenceWithoutTheUseOfWrappedFunctions().newBuilder().registerTypeAdapterFactory((TypeAdapterFactory)new DocumentedTypeAdapterFactory());
        return gsonBuilder.create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public static Gson getDocumentGson() {
        Object $value = documentGson.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = documentGson;
            synchronized (atomicReference) {
                $value = documentGson.get();
                if ($value == null) {
                    Gson actualValue = ModuleConfigurationsDocumentBuilder.makeDocumentGson();
                    $value = actualValue == null ? documentGson : actualValue;
                    documentGson.set($value);
                }
            }
        }
        return (Gson)($value == documentGson ? null : $value);
    }
}

