/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.document.builder;

import io.github.sakurawald.fuji.core.auxiliary.ReflectionUtil;
import io.github.sakurawald.fuji.core.document.auxiliary.DocumentUtil;
import io.github.sakurawald.fuji.core.document.structure.JobDescriptor;
import io.github.sakurawald.fuji.module.initializer.document.builder.DocumentBuilder;
import io.github.sakurawald.fuji.module.initializer.document.builder.DocumentBuilderContext;
import io.github.sakurawald.fuji.module.initializer.document.compiler.DocumentCompiler;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ModuleJobsDocumentBuilder
extends DocumentBuilder {
    @Override
    public void build(@NotNull DocumentBuilderContext documentBuilderContext) {
        List<JobDescriptor> jobs = DocumentUtil.getJobDescriptors().stream().filter(it -> it.getSourceModule().equals(documentBuilderContext.getModulePathString())).toList();
        if (!jobs.isEmpty()) {
            documentBuilderContext.getDocumentBuilder().append("## Jobs").append(System.lineSeparator());
            jobs.forEach(it -> this.build(documentBuilderContext, (JobDescriptor)it));
        }
    }

    private void build(@NotNull DocumentBuilderContext documentBuilderContext, @NotNull JobDescriptor jobDescriptor) {
        Class jobClass = jobDescriptor.getJobDetail().getJobClass();
        String jobSimpleClassName = ReflectionUtil.getSimpleClassName(jobClass);
        documentBuilderContext.getDocumentBuilder().append(":::job").append(System.lineSeparator()).append("- Job Name: `%s`".formatted(jobSimpleClassName)).append(System.lineSeparator());
        DocumentUtil.getClassDocumentString(null, jobClass).ifPresent(jobDocumentString -> {
            jobDocumentString = DocumentCompiler.compile(jobDocumentString);
            documentBuilderContext.getDocumentBuilder().append("- Document: %s".formatted(jobDocumentString)).append(System.lineSeparator());
        });
        documentBuilderContext.getDocumentBuilder().append(":::").append(System.lineSeparator());
    }
}

