/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.document.compiler;

import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class DocumentCompiler {
    @NotNull
    public static String compile(@NotNull String input) {
        return Arrays.stream(input.split("\n")).map(DocumentCompiler::compileLine).collect(Collectors.joining("\n"));
    }

    @NotNull
    private static String compileLine(@NotNull String input) {
        String output = input;
        for (String namedColor : TextHelper.Formatter.NAMED_STYLE_TAGS) {
            output = output.replaceAll("<\\/?" + namedColor + ">", "");
        }
        output = output.replaceAll("<\\/?#[a-zA-Z0-9_]+>", "");
        output = DocumentCompiler.unescapeTagsWithinInlineCodeFence(output);
        output = output.replaceAll("<=", "\\\\<=");
        return output;
    }

    @NotNull
    private static String unescapeTagsWithinInlineCodeFence(@NotNull String input) {
        Pattern codePattern = Pattern.compile("`([^`]+)`");
        Matcher matcher = codePattern.matcher(input);
        StringBuilder result = new StringBuilder();
        while (matcher.find()) {
            String codeBlock = matcher.group(1);
            String unescaped = codeBlock.replaceAll("\\\\([<>])", "$1");
            matcher.appendReplacement(result, "`" + Matcher.quoteReplacement(unescaped) + "`");
        }
        matcher.appendTail(result);
        return result.toString();
    }
}

