/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.document.config.writter;

import com.google.gson.stream.JsonWriter;
import io.github.sakurawald.fuji.core.auxiliary.ReflectionUtil;
import io.github.sakurawald.fuji.core.document.auxiliary.DocumentUtil;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public class DocumentJsonWriter
extends JsonWriter {
    private final JsonWriter delegate;
    private final Map<String, String> documentStringMap;

    public DocumentJsonWriter(JsonWriter delegate, Map<String, String> documentStringMap) {
        super(DocumentJsonWriter.getBackendWriter(delegate));
        this.delegate = delegate;
        this.documentStringMap = documentStringMap;
        this.setPrettyFormatting();
    }

    private void setPrettyFormatting() {
    }

    public JsonWriter name(String name) throws IOException {
        Optional<String> documentString = Optional.ofNullable(this.documentStringMap.get(name));
        if (documentString.isPresent()) {
            Writer underlyingWriter = DocumentJsonWriter.getBackendWriter(this.delegate);
            String formattedDocumentString = documentString.get().trim();
            formattedDocumentString = DocumentUtil.Indenter.indentExceptFirstLine(formattedDocumentString, this.getIndent());
            underlyingWriter.append(this.getLineSeparator()).append(this.getIndent()).append("/* ").append(formattedDocumentString).append(" */");
        }
        return super.name(name);
    }

    @NotNull
    private static Writer getBackendWriter(@NotNull JsonWriter jsonWriter) {
        return ReflectionUtil.Reflection.getInstanceFieldValue(jsonWriter, "out", Writer.class);
    }

    @NotNull
    private String getIndent() {
        return ReflectionUtil.Reflection.getInstanceFieldValue((Object)this, "indent", String.class);
    }

    @NotNull
    private String getLineSeparator() {
        return ReflectionUtil.Reflection.getInstanceFieldValue((Object)this, "separator", String.class);
    }
}

