/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.document.structure;

import io.github.sakurawald.fuji.Fuji;
import io.github.sakurawald.fuji.core.manager.impl.module.ModulePathResolver;
import io.github.sakurawald.fuji.module.initializer.document.builder.DocumentBuilderContext;
import io.github.sakurawald.fuji.module.initializer.document.builder.ModuleArgumentTypeAdaptersDocumentBuilder;
import io.github.sakurawald.fuji.module.initializer.document.builder.ModuleColorBoxesDocumentBuilder;
import io.github.sakurawald.fuji.module.initializer.document.builder.ModuleCommandsDocumentBuilder;
import io.github.sakurawald.fuji.module.initializer.document.builder.ModuleConfigurationsDocumentBuilder;
import io.github.sakurawald.fuji.module.initializer.document.builder.ModuleJobsDocumentBuilder;
import io.github.sakurawald.fuji.module.initializer.document.builder.ModuleOverviewDocumentBuilder;
import io.github.sakurawald.fuji.module.initializer.document.builder.ModulePlaceholdersDocumentBuilder;
import io.github.sakurawald.fuji.module.initializer.document.builder.ReadmeDocumentBuilder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.jetbrains.annotations.NotNull;

public class DocumentBuilderDriver {
    public static final Path DOCUMENT_BUILD_DIR = Fuji.MOD_CONFIG_PATH.resolve("document");

    public static void buildAll() {
        DocumentBuilderDriver.buildReadme();
        DocumentBuilderDriver.buildModules();
    }

    private static void buildReadme() {
        StringBuilder documentBuilder = new StringBuilder();
        DocumentBuilderContext documentBuilderContext = new DocumentBuilderContext("core", documentBuilder);
        new ReadmeDocumentBuilder().build(documentBuilderContext);
        String readmeFileString = documentBuilder.toString();
        Path readmeFilePath = DOCUMENT_BUILD_DIR.resolve("01-README.md");
        Files.createDirectories(readmeFilePath.getParent(), new FileAttribute[0]);
        Files.writeString(readmeFilePath, (CharSequence)readmeFileString, new OpenOption[0]);
    }

    private static void buildModules() {
        DocumentBuilderDriver.buildModule("core");
        ModulePathResolver.DECLARED_MODULE_PATH_STRINGS.forEach(DocumentBuilderDriver::buildModule);
    }

    private static void buildModule(@NotNull String modulePathString) {
        StringBuilder documentBuilder = new StringBuilder();
        DocumentBuilderContext documentBuilderContext = new DocumentBuilderContext(modulePathString, documentBuilder);
        new ModuleOverviewDocumentBuilder().build(documentBuilderContext);
        new ModuleColorBoxesDocumentBuilder().build(documentBuilderContext);
        new ModuleConfigurationsDocumentBuilder().build(documentBuilderContext);
        new ModuleJobsDocumentBuilder().build(documentBuilderContext);
        new ModuleCommandsDocumentBuilder().build(documentBuilderContext);
        new ModulePlaceholdersDocumentBuilder().build(documentBuilderContext);
        new ModuleArgumentTypeAdaptersDocumentBuilder().build(documentBuilderContext);
        String documentFileString = documentBuilder.toString();
        String moduleDocumentFileName = DocumentBuilderDriver.getModuleDocumentFileName(modulePathString);
        Path documentFilePath = DOCUMENT_BUILD_DIR.resolve("02-Modules").resolve(moduleDocumentFileName);
        Files.createDirectories(documentFilePath.getParent(), new FileAttribute[0]);
        Files.writeString(documentFilePath, (CharSequence)documentFileString, new OpenOption[0]);
    }

    private static String getModuleDocumentFileName(@NotNull String modulePathString) {
        return modulePathString + ".md";
    }
}

