/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.echo.send_custom;

import eu.pb4.sgui.api.elements.BookElementBuilder;
import eu.pb4.sgui.api.gui.BookGui;
import io.github.sakurawald.fuji.core.auxiliary.ReflectionUtil;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.command.annotation.CommandNode;
import io.github.sakurawald.fuji.core.command.annotation.CommandRequirement;
import io.github.sakurawald.fuji.core.command.annotation.CommandSource;
import io.github.sakurawald.fuji.core.command.exception.AbortCommandExecutionException;
import io.github.sakurawald.fuji.core.document.annotation.ColorBox;
import io.github.sakurawald.fuji.core.document.annotation.ColorBoxes;
import io.github.sakurawald.fuji.core.document.annotation.Document;
import io.github.sakurawald.fuji.core.service.paged_text.PagedBookText;
import io.github.sakurawald.fuji.core.service.paged_text.PagedMessageText;
import io.github.sakurawald.fuji.module.initializer.ModuleInitializer;
import io.github.sakurawald.fuji.module.initializer.echo.send_custom.command.argument.wrapper.CustomTextName;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

@Document(id=1751976654799L, value="This module provides `/send-custom` command.\nTo define `custom text` and auto-page them.\nAnd then send it `as message` or `as book` to a specified player.\n")
@ColorBoxes(value={@ColorBox(id=1753055756228L, color=ColorBox.ColorBoxTypes.EXAMPLE, value="\u25c9 Download the example custom text.\nYou can download the `example-custom-text.txt` file.\nIt is in https://github.com/sakurawald/fuji/blob/dev/.github/files/example-custom-text.txt\n"), @ColorBox(id=1751976733551L, color=ColorBox.ColorBoxTypes.EXAMPLE, value="\u25c9 Send a custom text as a book.\nIssue: `/send-custom as-book Alice guide --author \"alice\" --title \"<rb>The Guide\" --giveBook true --openBook true`\n\n\u25c9 Send a custom text as a message.\nIssue: `/send-custom as-message Alice guide`\n"), @ColorBox(id=1753331827763L, color=ColorBox.ColorBoxTypes.TIP, value="\u25c9 Ensure the players are allowed to use `/command-callback` command.\nThe `/command-callback` command is a fuji command, used for `click event`.\nIn vanilla Minecraft, if a player has `no permission` to use that command, the client will says `Unknown Command` error.\n")})
@CommandNode(value="send-custom")
@CommandRequirement(level=4)
public class SendCustomInitializer
extends ModuleInitializer {
    public static final Path CUSTOM_TEXT_DIR_PATH = ReflectionUtil.computeModuleConfigPath(SendCustomInitializer.class).resolve("custom-text");

    private static String withCustomText(class_3222 player, CustomTextName name) {
        String value = (String)name.getValue();
        Path resolve = CUSTOM_TEXT_DIR_PATH.resolve(value);
        try {
            return Files.readString(resolve);
        }
        catch (IOException e) {
            TextHelper.sendTextByKey(player, "echo.send_custom.custom_text.not_found", value);
            throw new AbortCommandExecutionException();
        }
    }

    @Document(id=1751826990344L, value="Send the `custom text` as a `message`.")
    @CommandNode(value="as-message")
    private static int $asMessage(@CommandSource class_2168 source, class_3222 player, CustomTextName name) {
        String string = SendCustomInitializer.withCustomText(player, name);
        PagedMessageText pagedMessageText = new PagedMessageText(player, string);
        pagedMessageText.sendPage(player, 0);
        return 1;
    }

    @Document(id=1751826992414L, value="Send the `custom text` as a `book`.")
    @CommandNode(value="as-book")
    private static int $asBook(@CommandSource class_2168 source, class_3222 player, CustomTextName customTextName, Optional<Boolean> openBook, Optional<Boolean> giveBook, Optional<String> title, Optional<String> author) {
        String string = SendCustomInitializer.withCustomText(player, customTextName);
        PagedBookText pagedText = new PagedBookText(player, string);
        BookElementBuilder bookElementBuilder = new BookElementBuilder();
        author.ifPresent(arg_0 -> ((BookElementBuilder)bookElementBuilder).setAuthor(arg_0));
        title.ifPresent(it -> bookElementBuilder.setName(TextHelper.getTextByValue(player, it, new Object[0])));
        pagedText.getPages().forEach(xva$0 -> bookElementBuilder.addPage(new class_2561[]{xva$0}));
        BookGui gui = new BookGui(player, bookElementBuilder){

            public void onTakeBookButton() {
                this.close();
            }
        };
        if (giveBook.orElse(true).booleanValue()) {
            class_1799 copy = gui.getBook().method_7972();
            player.method_7270(copy);
        }
        if (openBook.orElse(true).booleanValue()) {
            gui.open();
        }
        return 1;
    }

    @Override
    protected void onInitialize() {
        Files.createDirectories(CUSTOM_TEXT_DIR_PATH, new FileAttribute[0]);
    }
}

