/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.fuji.gui;

import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import io.github.sakurawald.fuji.core.auxiliary.ReflectionUtil;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.document.auxiliary.DocumentUtil;
import io.github.sakurawald.fuji.core.document.structure.JobDescriptor;
import io.github.sakurawald.fuji.core.gui.component.gui.PagedGui;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Trigger;

public class JobsInspectionGui
extends PagedGui<JobDescriptor> {
    public JobsInspectionGui(@Nullable SimpleGui parent, class_3222 player, @NotNull List<JobDescriptor> entities, int pageIndex) {
        super(parent, player, TextHelper.getTextByKey(player, "fuji.inspect.jobs.gui.title", new Object[0]), entities, pageIndex);
    }

    @Override
    protected PagedGui<JobDescriptor> makePage(@Nullable SimpleGui parent, @NotNull class_3222 player, class_2561 title, @NotNull List<JobDescriptor> entities, int pageIndex) {
        return new JobsInspectionGui(parent, player, entities, pageIndex);
    }

    public static JobsInspectionGui inspectAll(SimpleGui parent, class_3222 player) {
        List<JobDescriptor> entities = DocumentUtil.getJobDescriptors();
        return new JobsInspectionGui(parent, player, entities, 0);
    }

    private List<Date> getFireDates(Trigger trigger) {
        ArrayList<Date> fireDates = new ArrayList<Date>();
        Date baseTime = trigger.getPreviousFireTime();
        fireDates.add(baseTime);
        for (int i = 0; i < 5; ++i) {
            Date fireTimeAfter = trigger.getFireTimeAfter(baseTime);
            fireDates.add(fireTimeAfter);
            baseTime = fireTimeAfter;
        }
        return fireDates;
    }

    @Override
    @NotNull
    protected GuiElementInterface toGuiElement(@NotNull JobDescriptor entity) {
        JobDetail jobDetail = entity.jobDetail;
        JobKey jobKey = jobDetail.getKey();
        String sourceModule = entity.getSourceModule();
        ArrayList<class_2561> lore = new ArrayList<class_2561>();
        lore.add(TextHelper.getTextByKey(this.getPlayer(), "from_module", sourceModule));
        Class jobClass = jobDetail.getJobClass();
        lore.add(TextHelper.getTextByKey(this.getPlayer(), "job.class", ReflectionUtil.getSimpleClassName(jobClass)));
        lore.add(TextHelper.getTextByKey(this.getPlayer(), "job.job_group", TextHelper.Parsers.escapeTags(jobKey.getGroup())));
        lore.add(TextHelper.getTextByKey(this.getPlayer(), "job.job_name", TextHelper.Parsers.escapeTags(jobKey.getName())));
        entity.getTriggersOfJob().forEach(trigger -> {
            lore.add(TextHelper.getTextByKey(this.getPlayer(), "job.fire_dates", new Object[0]));
            this.getFireDates((Trigger)trigger).forEach(fireDate -> lore.add(TextHelper.getTextByKey(this.getPlayer(), "job.fire_dates.entry", fireDate)));
        });
        DocumentUtil.getClassDocumentString(this.getPlayer(), jobClass).ifPresent(jobDocument -> {
            lore.add(TextHelper.TEXT_EMPTY);
            lore.addAll(TextHelper.getDocumentTextList(this.getPlayer(), jobDocument));
        });
        GuiElementBuilder guiElementBuilder = new GuiElementBuilder().setItem(class_1802.field_8557).setName(TextHelper.getTextByKey(this.getPlayer(), "fuji.inspect.jobs.gui.item.name", new Object[0])).setLore(lore);
        return guiElementBuilder.build();
    }
}

