/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.gameplay.carpet.fake_player_manager.job;

import io.github.sakurawald.fuji.core.annotation.Unused;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.EntityHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.PlayerHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.document.annotation.Document;
import io.github.sakurawald.fuji.core.event.annotation.EventConsumer;
import io.github.sakurawald.fuji.core.event.message.server.lifecycle.ServerStartedEvent;
import io.github.sakurawald.fuji.core.job.abst.CronJob;
import io.github.sakurawald.fuji.core.manager.Managers;
import io.github.sakurawald.fuji.module.initializer.gameplay.carpet.fake_player_manager.service.FakePlayerManagerService;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.quartz.JobExecutionContext;

@Document(id=1751827017263L, value="This `job` is used to check the `fake-player caps limit` for each player.\n")
public class ManageFakePlayersJob
extends CronJob {
    public ManageFakePlayersJob() {
        super(() -> "0 * * ? * * *");
    }

    @EventConsumer
    private static void scheduleFakePlayerJob(@Unused ServerStartedEvent event) {
        ManageFakePlayersJob manageFakePlayersJob = new ManageFakePlayersJob();
        Managers.getScheduleManager().scheduleJob(manageFakePlayersJob);
    }

    public void execute(@NotNull JobExecutionContext context) {
        ManageFakePlayersJob.checkCapsLimit();
    }

    private static void checkCapsLimit() {
        ManageFakePlayersJob.removeInvalidFakePlayerNameEntries();
        int capsLimit = FakePlayerManagerService.getFakePlayerCapsLimit();
        long currentTimeMs = System.currentTimeMillis();
        FakePlayerManagerService.player2fakePlayers.entrySet().forEach(entry -> {
            String ownerPlayerName = (String)entry.getKey();
            long expirationTimeOfTheOwnerPlayer = FakePlayerManagerService.player2expiration.computeIfAbsent(ownerPlayerName, k -> -1L);
            Integer[] allowedFakePlayersCount = new Integer[]{0};
            List newValue = ((List)entry.getValue()).stream().filter(fakePlayerName -> {
                Optional<class_3222> fakePlayer = PlayerHelper.Lookup.getOnlinePlayerByNameIgnoreCase(fakePlayerName);
                if (fakePlayer.isEmpty()) {
                    return false;
                }
                class_3222 $fakePlayer = fakePlayer.get();
                if (currentTimeMs >= expirationTimeOfTheOwnerPlayer) {
                    Optional<class_3222> ownerPlayer = PlayerHelper.Lookup.getOnlinePlayerByNameIgnoreCase(ownerPlayerName);
                    if (ownerPlayer.isPresent()) {
                        FakePlayerManagerService.renewMyFakePlayers(ownerPlayer.get());
                        return true;
                    }
                    EntityHelper.killEntity((class_1297)$fakePlayer);
                    TextHelper.sendBroadcastByKey("fake_player_manager.kick_for_expiration", PlayerHelper.getPlayerName((class_1657)$fakePlayer), ownerPlayerName);
                    return false;
                }
                if (allowedFakePlayersCount[0] < capsLimit) {
                    Integer n = allowedFakePlayersCount[0];
                    allowedFakePlayersCount[0] = allowedFakePlayersCount[0] + 1;
                    return true;
                }
                EntityHelper.killEntity((class_1297)$fakePlayer);
                TextHelper.sendBroadcastByKey("fake_player_manager.kick_for_amount", PlayerHelper.getPlayerName((class_1657)$fakePlayer), ownerPlayerName);
                return false;
            }).collect(Collectors.toList());
            entry.setValue(newValue);
        });
    }

    private static void removeInvalidFakePlayerNameEntries() {
        FakePlayerManagerService.player2fakePlayers.values().forEach(value -> value.removeIf(fakePlayerName -> {
            Optional<class_3222> fakePlayer = PlayerHelper.Lookup.getOnlinePlayerByNameIgnoreCase(fakePlayerName);
            return fakePlayer.isEmpty() || fakePlayer.get().method_31481();
        }));
    }
}

