/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.head.privoder;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import io.github.sakurawald.fuji.core.auxiliary.LogUtil;
import io.github.sakurawald.fuji.core.auxiliary.ReflectionUtil;
import io.github.sakurawald.fuji.core.config.mapper.GsonMapper;
import io.github.sakurawald.fuji.core.structure.Downloader;
import io.github.sakurawald.fuji.module.initializer.head.HeadInitializer;
import io.github.sakurawald.fuji.module.initializer.head.structure.Category;
import io.github.sakurawald.fuji.module.initializer.head.structure.Head;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;

public class HeadProvider {
    private static final Path HEAD_DATA_DIR_PATH = ReflectionUtil.computeModuleConfigPath(HeadInitializer.class).resolve("head-data").toAbsolutePath();
    private static final String HEAD_DATABASE_API = "https://minecraft-heads.com/scripts/api.php?cat=%s&tags=true";
    private static final AtomicReference<Object> loadedHeads = new AtomicReference();

    private static Path computePath(Category category) {
        return HEAD_DATA_DIR_PATH.resolve(category.name + ".json");
    }

    public static Multimap<Category, Head> syncCategories() {
        final HashMultimap result = HashMultimap.create();
        for (final Category category : Category.values()) {
            String urlString = null;
            try {
                Path destination = HeadProvider.computePath(category);
                if (Files.exists(destination, new LinkOption[0])) {
                    HeadProvider.loadCategory((HashMultimap<Category, Head>)result, category);
                    continue;
                }
                urlString = HEAD_DATABASE_API.formatted(category.name);
                Downloader downloader = new Downloader(URI.create(urlString).toURL(), destination){

                    @Override
                    public void onComplete() {
                        HeadProvider.loadCategory((HashMultimap<Category, Head>)result, category);
                    }
                };
                downloader.startDownload();
            }
            catch (IOException e) {
                LogUtil.warn("Failed to download heads file from URL {}", urlString);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadCategory(HashMultimap<Category, Head> result, Category category) {
        try {
            LogUtil.debug("Load head category: {}", category.name);
            Path path = HeadProvider.computePath(category);
            InputStreamReader reader = new InputStreamReader(Files.newInputStream(path, new OpenOption[0]), StandardCharsets.UTF_8);
            try {
                JsonArray headJsonArray = JsonParser.parseReader((Reader)reader).getAsJsonArray();
                for (JsonElement headJsonElement : headJsonArray) {
                    try {
                        Head head = GsonMapper.fromJson(headJsonElement, Head.class);
                        result.put((Object)category, (Object)head);
                    }
                    catch (Exception e) {
                        LogUtil.error("Invalid head: {}", headJsonElement, e);
                    }
                }
            }
            finally {
                if (Collections.singletonList(reader).get(0) != null) {
                    reader.close();
                }
            }
        }
        catch (Exception e) {
            LogUtil.error("Failed to load head category: {}", new Object[]{category, e});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public static Multimap<Category, Head> getLoadedHeads() {
        AtomicReference<Object> $value = loadedHeads.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = loadedHeads;
            synchronized (atomicReference) {
                $value = loadedHeads.get();
                if ($value == null) {
                    Multimap<Category, Head> actualValue = HeadProvider.syncCategories();
                    $value = actualValue == null ? loadedHeads : actualValue;
                    loadedHeads.set($value);
                }
            }
        }
        return (Multimap)($value == loadedHeads ? null : $value);
    }
}

