/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.jail.structure;

import io.github.sakurawald.fuji.core.auxiliary.ChronosUtil;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.PlayerHelper;
import io.github.sakurawald.fuji.core.document.annotation.Document;
import io.github.sakurawald.fuji.core.service.duration_parser.DurationParser;
import io.github.sakurawald.fuji.module.initializer.jail.service.JailService;
import io.github.sakurawald.fuji.module.initializer.jail.structure.JailDescriptor;
import lombok.Generated;

public class JailRecord {
    private boolean enable;
    @Document(id=1753685346716L, value="The `jailed player name`.")
    private String prisonerName;
    @Document(id=1753685321191L, value="The player name who created this `jail record`.")
    private String creatorName;
    private long createdTimestamp;
    private int specifiedJailSeconds;
    private int remainingJailSeconds;
    private String reason;
    private transient JailDescriptor ownerJailDescriptor;

    public static JailRecord make(String creatorName, String playerName, int jailSeconds, String reason) {
        JailRecord jailRecord = new JailRecord();
        jailRecord.setEnable(true);
        jailRecord.setCreatorName(creatorName);
        jailRecord.setCreatedTimestamp(System.currentTimeMillis());
        jailRecord.setPrisonerName(playerName);
        jailRecord.setSpecifiedJailSeconds(jailSeconds);
        jailRecord.setRemainingJailSeconds(jailSeconds);
        jailRecord.setReason(reason);
        return jailRecord;
    }

    public String getSpecifiedJailDuration() {
        return DurationParser.formatSeconds(this.getSpecifiedJailSeconds());
    }

    public String getRemainingJailDuration() {
        return DurationParser.formatSeconds(this.getRemainingJailSeconds());
    }

    public String getFormattedCreatedTimestamp() {
        return ChronosUtil.Formatter.formatDate(this.getCreatedTimestamp());
    }

    public void onUpdateRecord(int passedTimeInMillSeconds) {
        if (this.getOwnerJailDescriptor().isCountRemainingJailSecondsWhenPrisonersOffline()) {
            this.countRemainingJailSeconds(passedTimeInMillSeconds);
        } else if (PlayerHelper.isPlayerOnline(this.prisonerName)) {
            this.countRemainingJailSeconds(passedTimeInMillSeconds);
        }
    }

    private void countRemainingJailSeconds(int passedTimeInMillSeconds) {
        int previousValue = this.getRemainingJailSeconds();
        int newValue = previousValue - passedTimeInMillSeconds / 1000;
        newValue = Math.max(newValue, 0);
        this.setRemainingJailSeconds(newValue);
        if (newValue == 0 && previousValue != 0) {
            JailService.deactivateJailRecord(this);
        }
    }

    @Generated
    public boolean isEnable() {
        return this.enable;
    }

    @Generated
    public String getPrisonerName() {
        return this.prisonerName;
    }

    @Generated
    public String getCreatorName() {
        return this.creatorName;
    }

    @Generated
    public long getCreatedTimestamp() {
        return this.createdTimestamp;
    }

    @Generated
    public int getSpecifiedJailSeconds() {
        return this.specifiedJailSeconds;
    }

    @Generated
    public int getRemainingJailSeconds() {
        return this.remainingJailSeconds;
    }

    @Generated
    public String getReason() {
        return this.reason;
    }

    @Generated
    public JailDescriptor getOwnerJailDescriptor() {
        return this.ownerJailDescriptor;
    }

    @Generated
    public JailRecord setEnable(boolean enable) {
        this.enable = enable;
        return this;
    }

    @Generated
    public JailRecord setPrisonerName(String prisonerName) {
        this.prisonerName = prisonerName;
        return this;
    }

    @Generated
    public JailRecord setCreatorName(String creatorName) {
        this.creatorName = creatorName;
        return this;
    }

    @Generated
    public JailRecord setCreatedTimestamp(long createdTimestamp) {
        this.createdTimestamp = createdTimestamp;
        return this;
    }

    @Generated
    public JailRecord setSpecifiedJailSeconds(int specifiedJailSeconds) {
        this.specifiedJailSeconds = specifiedJailSeconds;
        return this;
    }

    @Generated
    public JailRecord setRemainingJailSeconds(int remainingJailSeconds) {
        this.remainingJailSeconds = remainingJailSeconds;
        return this;
    }

    @Generated
    public JailRecord setReason(String reason) {
        this.reason = reason;
        return this;
    }

    @Generated
    public JailRecord setOwnerJailDescriptor(JailDescriptor ownerJailDescriptor) {
        this.ownerJailDescriptor = ownerJailDescriptor;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JailRecord)) {
            return false;
        }
        JailRecord other = (JailRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnable() != other.isEnable()) {
            return false;
        }
        if (this.getCreatedTimestamp() != other.getCreatedTimestamp()) {
            return false;
        }
        if (this.getSpecifiedJailSeconds() != other.getSpecifiedJailSeconds()) {
            return false;
        }
        if (this.getRemainingJailSeconds() != other.getRemainingJailSeconds()) {
            return false;
        }
        String this$prisonerName = this.getPrisonerName();
        String other$prisonerName = other.getPrisonerName();
        if (this$prisonerName == null ? other$prisonerName != null : !this$prisonerName.equals(other$prisonerName)) {
            return false;
        }
        String this$creatorName = this.getCreatorName();
        String other$creatorName = other.getCreatorName();
        if (this$creatorName == null ? other$creatorName != null : !this$creatorName.equals(other$creatorName)) {
            return false;
        }
        String this$reason = this.getReason();
        String other$reason = other.getReason();
        return !(this$reason == null ? other$reason != null : !this$reason.equals(other$reason));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof JailRecord;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnable() ? 79 : 97);
        long $createdTimestamp = this.getCreatedTimestamp();
        result = result * 59 + (int)($createdTimestamp >>> 32 ^ $createdTimestamp);
        result = result * 59 + this.getSpecifiedJailSeconds();
        result = result * 59 + this.getRemainingJailSeconds();
        String $prisonerName = this.getPrisonerName();
        result = result * 59 + ($prisonerName == null ? 43 : $prisonerName.hashCode());
        String $creatorName = this.getCreatorName();
        result = result * 59 + ($creatorName == null ? 43 : $creatorName.hashCode());
        String $reason = this.getReason();
        result = result * 59 + ($reason == null ? 43 : $reason.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "JailRecord(enable=" + this.isEnable() + ", prisonerName=" + this.getPrisonerName() + ", creatorName=" + this.getCreatorName() + ", createdTimestamp=" + this.getCreatedTimestamp() + ", specifiedJailSeconds=" + this.getSpecifiedJailSeconds() + ", remainingJailSeconds=" + this.getRemainingJailSeconds() + ", reason=" + this.getReason() + ")";
    }

    @Generated
    public JailRecord() {
    }

    @Generated
    public JailRecord(boolean enable, String prisonerName, String creatorName, long createdTimestamp, int specifiedJailSeconds, int remainingJailSeconds, String reason, JailDescriptor ownerJailDescriptor) {
        this.enable = enable;
        this.prisonerName = prisonerName;
        this.creatorName = creatorName;
        this.createdTimestamp = createdTimestamp;
        this.specifiedJailSeconds = specifiedJailSeconds;
        this.remainingJailSeconds = remainingJailSeconds;
        this.reason = reason;
        this.ownerJailDescriptor = ownerJailDescriptor;
    }
}

