/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.leaderboard;

import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.command.annotation.CommandNode;
import io.github.sakurawald.fuji.core.command.annotation.CommandRequirement;
import io.github.sakurawald.fuji.core.command.annotation.CommandSource;
import io.github.sakurawald.fuji.core.config.handler.abst.BaseConfigurationHandler;
import io.github.sakurawald.fuji.core.config.handler.impl.ObjectConfigurationHandler;
import io.github.sakurawald.fuji.core.document.annotation.ColorBox;
import io.github.sakurawald.fuji.core.document.annotation.ColorBoxes;
import io.github.sakurawald.fuji.core.document.annotation.Document;
import io.github.sakurawald.fuji.core.event.annotation.EventConsumer;
import io.github.sakurawald.fuji.core.event.message.player.PlayerJoinedEvent;
import io.github.sakurawald.fuji.core.event.message.player.PlayerLeftEvent;
import io.github.sakurawald.fuji.core.manager.Managers;
import io.github.sakurawald.fuji.core.service.paged_text.PagedMessageText;
import io.github.sakurawald.fuji.module.initializer.ModuleInitializer;
import io.github.sakurawald.fuji.module.initializer.leaderboard.LeaderBoardPlaceholders;
import io.github.sakurawald.fuji.module.initializer.leaderboard.config.model.LeaderBoardConfigModel;
import io.github.sakurawald.fuji.module.initializer.leaderboard.config.model.LeaderBoardDataModel;
import io.github.sakurawald.fuji.module.initializer.leaderboard.job.UpdateLeaderboardsJob;
import io.github.sakurawald.fuji.module.initializer.leaderboard.service.LeaderBoardService;
import io.github.sakurawald.fuji.module.initializer.leaderboard.structure.LeaderBoardDescriptor;
import io.github.sakurawald.fuji.module.initializer.leaderboard.structure.LeaderBoardSnapshot;
import io.github.sakurawald.fuji.module.initializer.leaderboard.structure.LeaderBoardTimeWindow;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Optional;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

@Document(id=1753466282781L, value="This module allows you to define a `leaderboard`.\nThe `score provider` of a `leaderboard` can be a `placeholder`, `statistics` or `objective`.\nThe `time window` of a `leaderboard` can be `hourly`, `daily`, `weekly`, `monthly`, `yearly` and `all_time`.\nYou can display the `leaderboard` using `placeholders` or `commands`.\n")
@ColorBoxes(value={@ColorBox(id=1753491862403L, color=ColorBox.ColorBoxTypes.NOTE, value="\u25c9 How it works?\n1. You need to define a `leaderboard` in the config file.\n2. The defined `leaderboards` will be `updated` if:\n2.a. All leaderboards will be updated when a player `joins` or `leaves` the server.\n2.b. All leaderboards will be updated when the `Leaderboard Updater Job` is `fired`.\n2.c. You can use `/leaderboard update-all` command to update manually.\n3. You can `display` the leaderboard in various ways.\n3.a. You can use `placeholders` to display the `leaderboard`.\n3.b. You can use `commands` to display the `leaderboard`.\n"), @ColorBox(id=1753498010821L, color=ColorBox.ColorBoxTypes.TIP, value="\u25c9 You can use a `placeholder` to fetch data from `statistics`.\nFor example:\n1. `%player:statistic_raw minecraft:deaths%`\n2. `%player:statistic_raw minecraft:killed minecraft:zombie%`\n\nSee more `statistics` in: https://minecraft.wiki/w/Statistics\n\n\u25c9 You can use a `placeholder` to fetch data from `objective`.\nFor example: `%player:objective [objective]%`\n"), @ColorBox(id=1753492108539L, color=ColorBox.ColorBoxTypes.EXAMPLE, value="\u25c9 How to define a `leaderboard`?\nTo define a `leaderboard`, you need to specify:\n1. `Leaderboard ID`: The unique name for this leaderboard.\n2. `Score Provider`: It's a string which evaluates to a `numeric value`. (Typically a `placeholder`)\n\n\u25c9 What is the `lowest N` and `highest N`.\nFor any leaderboard, all its `scores` are `sorted` in `natural order`.\nThe `natural order` is the order that from `lowest` to `highest`. (e.g. `0`, `1`, `2`, `3` ...)\n\nYou can use a `lowest placeholder` to select `the lowest N score`.\nYou can use a `highest placeholder` to select `the highest N score`.\n\nFor example, you may want to `select` the `lowest score` for `death-board`, and `highest score` for `zombie-kill-board`.\n1. `%fuji:lowest_n_score death-board 1 all_time%`\n2. `%fuji:highest_n_score zombie-kill-board 1 all_time%`\n"), @ColorBox(id=1753497840128L, color=ColorBox.ColorBoxTypes.EXAMPLE, value="\u25c9 List the specified `leaderboard` with `lowest first` order.\nIssue: `/leaderboard lowest death-board ALL_TIME`\n\n\u25c9 List the specified `leaderboard` with `highest first` order.\nIssue: `/leaderboard highest zombie-kill-board ALL_TIME`\n\n\u25c9 List the specified `leaderboard` with `highest first` order and `daily` time window.\nIssue: `/leaderboard highest zombie-kill-board DAILY`\n\n\u25c9 Award the top player.\nIssue:\n1. `/run as console send-broadcast <green>The greatest zombie killer this week is %fuji:highest_n_name zombie-kill-board 1 weekly%`\n2. `/run as console give %fuji:highest_n_name zombie-kill-board 1 weekly% minecraft:diamond 1`\n")})
public class LeaderBoardInitializer
extends ModuleInitializer {
    public static final BaseConfigurationHandler<LeaderBoardConfigModel> config = ObjectConfigurationHandler.ofModule("config.json", LeaderBoardConfigModel.class);
    public static final BaseConfigurationHandler<LeaderBoardDataModel> data = ObjectConfigurationHandler.ofModule("leaderboard-data.json", LeaderBoardDataModel.class);

    @Document(id=1753467248049L, value="Update all `leaderboards` for `online players`.")
    @CommandNode(value="leaderboard update-all")
    @CommandRequirement(level=4)
    private static int $updateAll(@CommandSource class_2168 source) {
        LeaderBoardService.updateLeaderBoards();
        TextHelper.sendTextByKey(source, "leaderboard.update.all", new Object[0]);
        return 1;
    }

    @Document(id=1753493701376L, value="List the lowest N players for specified leaderboard.")
    @CommandNode(value="leaderboard lowest")
    @CommandRequirement(level=4)
    private static int $lowest(@CommandSource class_3222 player, @NotNull LeaderBoardDescriptor leaderboard, @NotNull LeaderBoardTimeWindow timeWindow, Optional<Integer> pageSize) {
        LeaderBoardInitializer.printLeaderBoardAsPagedMessage(player, leaderboard, timeWindow, pageSize, false);
        return 1;
    }

    @Document(id=1753496925314L, value="List the highest N players for specified leaderboard.")
    @CommandNode(value="leaderboard highest")
    @CommandRequirement(level=4)
    private static int $highest(@CommandSource class_3222 player, @NotNull LeaderBoardDescriptor leaderboard, @NotNull LeaderBoardTimeWindow timeWindow, Optional<Integer> pageSize) {
        LeaderBoardInitializer.printLeaderBoardAsPagedMessage(player, leaderboard, timeWindow, pageSize, true);
        return 1;
    }

    private static void printLeaderBoardAsPagedMessage(class_3222 player, @NotNull LeaderBoardDescriptor leaderboard, @NotNull LeaderBoardTimeWindow timeWindow, Optional<Integer> pageSize, boolean reversed) {
        Integer $pageSize = pageSize.filter(i -> i != 0).orElseGet(LeaderBoardService::getDefaultPageSize);
        TextHelper.sendTextByKey(player, "leaderboard.list.header", leaderboard.getDisplayName(), timeWindow.toLanguageValue(player));
        ArrayList<LeaderBoardSnapshot> leaderBoardSnapshots = new ArrayList<LeaderBoardSnapshot>(LeaderBoardService.getLeaderBoardSnapshots(leaderboard, timeWindow));
        if (reversed) {
            leaderBoardSnapshots.sort(Comparator.comparing(LeaderBoardSnapshot::getEffectiveScore).reversed());
        } else {
            leaderBoardSnapshots.sort(Comparator.comparing(LeaderBoardSnapshot::getEffectiveScore));
        }
        PagedMessageText pagedMessageText = PagedMessageText.makePagedMessageText(player, leaderBoardSnapshots, $pageSize, (entity, index, pageBuilder) -> {
            int numbering = index + 1;
            String playerName = entity.getOwnerCache().getPlayerName();
            int score = entity.getEffectiveScore();
            class_2561 entryText = TextHelper.getTextByKey(player, "leaderboard.list.entry", numbering, playerName, score);
            pageBuilder.method_10852(entryText);
        });
        pagedMessageText.sendPage(player, 0);
    }

    @Override
    protected void registerPlaceholders() {
        LeaderBoardPlaceholders.registerLowestNPlayerNamePlaceholder();
        LeaderBoardPlaceholders.registerHighestNPlayerNamePlaceholder();
        LeaderBoardPlaceholders.registerLowestNScorePlaceholder();
        LeaderBoardPlaceholders.registerHighestNScorePlaceholder();
    }

    @Override
    protected void onInitialize() {
        Managers.getScheduleManager().scheduleJob(new UpdateLeaderboardsJob());
    }

    @EventConsumer
    private static void updateLeaderBoardOnPlayerJoined(PlayerJoinedEvent event) {
        LeaderBoardService.updateLeaderBoard(event.getPlayer());
    }

    @EventConsumer
    private static void updateLeaderBoardOnPlayerLeft(PlayerLeftEvent event) {
        LeaderBoardService.updateLeaderBoard(event.getPlayer());
    }
}

