/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.leaderboard.command.argument.adapter;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.CommandHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.command.argument.adapter.abst.BaseArgumentTypeAdapter;
import io.github.sakurawald.fuji.core.command.argument.structure.CommandArgument;
import io.github.sakurawald.fuji.core.command.exception.AbortCommandExecutionException;
import io.github.sakurawald.fuji.module.initializer.leaderboard.service.LeaderBoardService;
import io.github.sakurawald.fuji.module.initializer.leaderboard.structure.LeaderBoardDescriptor;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2168;
import org.jetbrains.annotations.NotNull;

public class LeaderBoardDescriptorArgumentTypeAdapter
extends BaseArgumentTypeAdapter {
    @Override
    protected ArgumentType<?> makeArgumentType() {
        return StringArgumentType.string();
    }

    @Override
    protected Object makeArgumentValue(@NotNull CommandContext<class_2168> context, @NotNull CommandArgument commandArgument) {
        String leaderBoardDescriptorId = StringArgumentType.getString(context, (String)commandArgument.getArgumentName());
        Optional<LeaderBoardDescriptor> leaderBoardDescriptor = LeaderBoardService.findLeaderBoardDescriptor(leaderBoardDescriptorId);
        if (leaderBoardDescriptor.isEmpty()) {
            TextHelper.sendTextByKey(context.getSource(), "leaderboard.not_found", leaderBoardDescriptorId);
            throw new AbortCommandExecutionException();
        }
        return leaderBoardDescriptor.get();
    }

    @Override
    public List<Class<?>> getTypeClasses() {
        return List.of(LeaderBoardDescriptor.class);
    }

    @Override
    public List<String> getTypeNames() {
        return List.of("leaderboard");
    }

    @Override
    @NotNull
    protected RequiredArgumentBuilder<class_2168, ?> makeRequiredArgumentBuilder(@NotNull String argumentName) {
        return super.makeRequiredArgumentBuilder(argumentName).suggests(CommandHelper.Suggestion.iterable(() -> LeaderBoardService.getLeaderBoardDescriptors().stream().map(LeaderBoardDescriptor::getLeaderboardId).toList()));
    }
}

