/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.leaderboard.service;

import io.github.sakurawald.fuji.core.auxiliary.LogUtil;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.PlayerHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.module.initializer.leaderboard.LeaderBoardInitializer;
import io.github.sakurawald.fuji.module.initializer.leaderboard.structure.LeaderBoardCache;
import io.github.sakurawald.fuji.module.initializer.leaderboard.structure.LeaderBoardData;
import io.github.sakurawald.fuji.module.initializer.leaderboard.structure.LeaderBoardDescriptor;
import io.github.sakurawald.fuji.module.initializer.leaderboard.structure.LeaderBoardSnapshot;
import io.github.sakurawald.fuji.module.initializer.leaderboard.structure.LeaderBoardTimeWindow;
import java.time.DayOfWeek;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

public class LeaderBoardService {
    public static List<LeaderBoardDescriptor> getLeaderBoardDescriptors() {
        return LeaderBoardInitializer.config.model().getLeaderboardDescriptors();
    }

    public static DayOfWeek getBeginningOfTheWeek() {
        return LeaderBoardInitializer.config.model().getBeginningOfTheWeek();
    }

    public static Optional<LeaderBoardDescriptor> findLeaderBoardDescriptor(String leaderBoardId) {
        return LeaderBoardService.getLeaderBoardDescriptors().stream().filter(it -> it.getLeaderboardId().equals(leaderBoardId)).findFirst();
    }

    public static int getDefaultPageSize() {
        return LeaderBoardInitializer.config.model().getPageSize();
    }

    public static List<LeaderBoardSnapshot> getLeaderBoardSnapshots(@NotNull LeaderBoardDescriptor descriptor, @NotNull LeaderBoardTimeWindow timeWindow) {
        return LeaderBoardService.withLeaderBoardData(descriptor, leaderBoardData -> leaderBoardData.getCaches().stream().map(it -> {
            LeaderBoardSnapshot snapshot = it.getSnapshot(timeWindow);
            snapshot.setOwnerCache((LeaderBoardCache)it);
            return snapshot;
        }).filter(LeaderBoardSnapshot::hasEffectiveScore).toList());
    }

    private static Optional<LeaderBoardSnapshot> getRankN(@NotNull LeaderBoardDescriptor descriptor, int rankN, boolean reversed, @NotNull LeaderBoardTimeWindow timeWindow) {
        ArrayList<LeaderBoardSnapshot> copyOfSnapshots = new ArrayList<LeaderBoardSnapshot>(LeaderBoardService.getLeaderBoardSnapshots(descriptor, timeWindow));
        if (rankN > copyOfSnapshots.size() || rankN <= 0) {
            return Optional.empty();
        }
        copyOfSnapshots.sort(Comparator.comparing(LeaderBoardSnapshot::getEffectiveScore));
        LeaderBoardSnapshot snapshot = reversed ? (LeaderBoardSnapshot)copyOfSnapshots.get(copyOfSnapshots.size() - rankN) : (LeaderBoardSnapshot)copyOfSnapshots.get(rankN - 1);
        return Optional.of(snapshot);
    }

    public static Optional<LeaderBoardSnapshot> getLowestN(@NotNull LeaderBoardDescriptor descriptor, int lowestN, @NotNull LeaderBoardTimeWindow timeWindow) {
        return LeaderBoardService.getRankN(descriptor, lowestN, false, timeWindow);
    }

    public static Optional<LeaderBoardSnapshot> getHighestN(@NotNull LeaderBoardDescriptor descriptor, int highestN, @NotNull LeaderBoardTimeWindow timeWindow) {
        return LeaderBoardService.getRankN(descriptor, highestN, true, timeWindow);
    }

    public static void updateLeaderBoards() {
        PlayerHelper.Lookup.getOnlinePlayers().forEach(LeaderBoardService::updateLeaderBoard);
    }

    public static void updateLeaderBoard(class_3222 player) {
        LogUtil.debug("Update leaderboards for player {}.", PlayerHelper.getPlayerName((class_1657)player));
        LeaderBoardService.getLeaderBoardDescriptors().forEach(descriptor -> LeaderBoardService.updateLeaderBoard(descriptor, player));
        LeaderBoardInitializer.data.writeStorage();
    }

    public static void updateLeaderBoard(LeaderBoardDescriptor leaderBoardDescriptor, class_3222 player) {
        int score;
        String leaderboardId = leaderBoardDescriptor.getLeaderboardId();
        String playerName = PlayerHelper.getPlayerName((class_1657)player);
        LogUtil.debug("Update leaderboard {} for player {}.", leaderboardId, playerName);
        String inputString = leaderBoardDescriptor.getScoreProvider();
        String outputString = TextHelper.Parsers.parsePlaceholderString(player, inputString);
        try {
            score = Integer.parseInt(outputString);
        }
        catch (NumberFormatException e) {
            LogUtil.warn("Failed to parse the score provider: leaderboard = {}, player = {}", leaderBoardDescriptor.getScoreProvider(), playerName);
            return;
        }
        LeaderBoardService.withLeaderBoardCache(leaderBoardDescriptor, playerName, cache -> {
            long updateTime = System.currentTimeMillis();
            cache.updateSnapshots(updateTime, score);
            return null;
        });
    }

    public static class_2561 getNonePlayerText() {
        return TextHelper.getTextByValue(null, LeaderBoardInitializer.config.model().getLeaderboardNoPlayerText(), new Object[0]);
    }

    public static class_2561 getNoScoreText() {
        return TextHelper.getTextByValue(null, LeaderBoardInitializer.config.model().getLeaderboardNoScoreText(), new Object[0]);
    }

    private static <T> T withLeaderBoardData(LeaderBoardDescriptor descriptor, Function<LeaderBoardData, T> function) {
        LeaderBoardData leaderBoardData = LeaderBoardInitializer.data.model().getLeaderboardData().stream().filter(it -> it.getLeaderboardId().equals(descriptor.getLeaderboardId())).findFirst().orElseGet(() -> {
            LeaderBoardData newValue = LeaderBoardData.make(descriptor.getLeaderboardId());
            LeaderBoardInitializer.data.model().getLeaderboardData().add(newValue);
            return newValue;
        });
        return function.apply(leaderBoardData);
    }

    private static <T> T withLeaderBoardCache(LeaderBoardDescriptor descriptor, String playerName, Function<LeaderBoardCache, T> function) {
        return (T)LeaderBoardService.withLeaderBoardData(descriptor, leaderBoardData -> {
            LeaderBoardCache leaderBoardCache = leaderBoardData.getCaches().stream().filter(it -> it.getPlayerName().equals(playerName)).findFirst().orElseGet(() -> {
                LeaderBoardCache newValue = LeaderBoardCache.of(playerName);
                leaderBoardData.getCaches().add(newValue);
                return newValue;
            });
            return function.apply(leaderBoardCache);
        });
    }
}

