/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.motd;

import com.google.common.base.Preconditions;
import com.mojang.authlib.GameProfile;
import io.github.sakurawald.fuji.core.auxiliary.LogUtil;
import io.github.sakurawald.fuji.core.auxiliary.RandomUtil;
import io.github.sakurawald.fuji.core.auxiliary.ReflectionUtil;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.config.handler.abst.BaseConfigurationHandler;
import io.github.sakurawald.fuji.core.config.handler.impl.ObjectConfigurationHandler;
import io.github.sakurawald.fuji.core.document.annotation.ColorBox;
import io.github.sakurawald.fuji.core.document.annotation.ColorBoxes;
import io.github.sakurawald.fuji.core.document.annotation.Document;
import io.github.sakurawald.fuji.core.event.annotation.EventConsumer;
import io.github.sakurawald.fuji.core.event.message.server.metadata.ModifyServerMetadataEvent;
import io.github.sakurawald.fuji.module.initializer.ModuleInitializer;
import io.github.sakurawald.fuji.module.initializer.motd.config.model.MotdConfigModel;
import io.github.sakurawald.fuji.module.initializer.motd.structure.MotdEntry;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import javax.imageio.ImageIO;
import net.minecraft.class_2561;
import net.minecraft.class_2926;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Document(id=1751826866342L, value="Customize the MOTD of the server.\n")
@ColorBoxes(value={@ColorBox(id=1751978213888L, color=ColorBox.ColorBoxTypes.EXAMPLE, value="\u25c9 Configure server icons.\nYou can put `64x64 pixels .png image file` into the directory `config/fuji/modules/motd/icon` dir.\nThe module will pick up a random image as the icon of the server.\nTo respond the server status request.\n"), @ColorBox(id=1751978273696L, color=ColorBox.ColorBoxTypes.TIP, value="\u25c9 Use an `editor` to help you design the MOTD.\nOnline MOTD editor: https://colorize.fun/en/minecraft\n"), @ColorBox(id=1753458678347L, color=ColorBox.ColorBoxTypes.TIP, value="\u25c9 Customize the MOTD using `Formating Codes`.\nThe `Formating Codes` is a vanilla Minecraft feature.\nSee: https://minecraft.fandom.com/wiki/Formatting_codes\n")})
public class MotdInitializer
extends ModuleInitializer {
    private static final BaseConfigurationHandler<MotdConfigModel> config = ObjectConfigurationHandler.ofModule("config.json", MotdConfigModel.class);
    private static final Path ICON_FOLDER = ReflectionUtil.computeModuleConfigPath(MotdInitializer.class).resolve("icon");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Optional<class_2926.class_8145> getEffectiveMotdIcon(@Nullable String preferIcon) {
        try {
            Files.createDirectories(ICON_FOLDER, new FileAttribute[0]);
            Stream<Path> temp = Files.list(ICON_FOLDER);
            try {
                File chooseItem;
                List<File> availableIcons = temp.map(Path::toFile).toList();
                if (preferIcon == null) {
                    if (availableIcons.isEmpty()) {
                        Optional<class_2926.class_8145> optional = Optional.empty();
                        return optional;
                    }
                    chooseItem = RandomUtil.drawList(availableIcons);
                } else {
                    chooseItem = ICON_FOLDER.resolve(preferIcon).toFile();
                }
                BufferedImage bufferedImage = ImageIO.read(chooseItem);
                Preconditions.checkState((bufferedImage.getWidth() == 64 ? 1 : 0) != 0, (Object)"Must be 64 pixels wide: %s".formatted(chooseItem));
                Preconditions.checkState((bufferedImage.getHeight() == 64 ? 1 : 0) != 0, (Object)"Must be 64 pixels high: %s".formatted(chooseItem));
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)bufferedImage, "PNG", byteArrayOutputStream);
                return Optional.of(new class_2926.class_8145(byteArrayOutputStream.toByteArray()));
            }
            finally {
                if (Collections.singletonList(temp).get(0) != null) {
                    temp.close();
                }
            }
        }
        catch (Exception e) {
            LogUtil.error("Failed to read icon file '{}', can't find it in '{}' directory.", preferIcon, ICON_FOLDER, e);
            return Optional.empty();
        }
    }

    @NotNull
    public static MotdEntry getEffectiveMotdEntry() {
        return RandomUtil.drawList(config.model().getMessages());
    }

    @NotNull
    public static class_2926.class_2927 getEffectivePlayersInfo(@NotNull class_2926.class_2927 original) {
        MotdConfigModel.PlayersInfo configSection = config.model().getPlayersInfo();
        int deltaMax = RandomUtil.getRandomNumber(configSection.getMaxPlayers().getDeltaMin(), configSection.getMaxPlayers().getDeltaMax());
        int max = original.comp_1279() + deltaMax;
        int deltaOnline = RandomUtil.getRandomNumber(configSection.getOnlinePlayers().getDeltaMin(), configSection.getOnlinePlayers().getDeltaMax());
        int online = original.comp_1280() + deltaOnline;
        List<GameProfile> sample = configSection.getHoverText().isEnable() ? configSection.getHoverText().getLines().stream().map(line -> TextHelper.Parsers.parsePlaceholderString(null, line)).map(line -> new GameProfile(UUID.randomUUID(), line)).toList() : original.comp_1281();
        return new class_2926.class_2927(max, online, (List)sample);
    }

    @NotNull
    public static class_2926.class_2930 getEffectiveVersion(class_2926.class_2930 original) {
        MotdConfigModel.VersionText configSection = config.model().getVersionText();
        if (configSection.isEnable()) {
            String text = configSection.getText();
            String gameVersion = TextHelper.Parsers.parsePlaceholderString(null, text);
            int protocolVersion = -42;
            return new class_2926.class_2930(gameVersion, protocolVersion);
        }
        return original;
    }

    @EventConsumer
    private static void onRequestServerMetadataHandler(ModifyServerMetadataEvent event) {
        class_2926 original = event.getServerMetadata();
        MotdEntry motdEntry = MotdInitializer.getEffectiveMotdEntry();
        class_2561 text = TextHelper.getTextByValue(null, motdEntry.getText(), new Object[0]);
        Optional<class_2926.class_8145> icon = MotdInitializer.getEffectiveMotdIcon(motdEntry.getIcon());
        Optional<class_2926.class_2927> players = original.comp_1274().map(MotdInitializer::getEffectivePlayersInfo);
        Optional<class_2926.class_2930> version = original.comp_1275().map(MotdInitializer::getEffectiveVersion);
        class_2926 serverMetadata = new class_2926(text, players, version, icon, original.comp_1277());
        event.setServerMetadata(serverMetadata);
    }
}

