/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.profiler.gui;

import eu.pb4.sgui.api.elements.GuiElement;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import io.github.sakurawald.fuji.core.auxiliary.StringUtil;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.RegistryHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.WorldHelper;
import io.github.sakurawald.fuji.module.initializer.profiler.ProfilerInitializer;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.nio.file.FileStore;
import java.nio.file.FileSystems;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_1948;
import net.minecraft.class_2561;
import net.minecraft.class_2818;
import net.minecraft.class_3193;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3917;

public class ProfilerGui
extends SimpleGui {
    private static final int LINE_SIZE = 9;
    private static final int CHUNK_AREA = (int)Math.pow(17.0, 2.0);

    public ProfilerGui(class_3222 player) {
        super(class_3917.field_17327, player, false);
        this.setTitle(TextHelper.getTextByKey(this.getPlayer(), "profiler.gui.title", new Object[0]));
        this.setSlot(0, this.makeOperatingSystemElement());
        this.setSlot(1, this.makeVirtualMachineElement());
        this.setSlot(3, this.makeCpuElement());
        this.setSlot(4, this.makeTpsElement());
        this.setSlot(5, this.makeMsptElement());
        List<GuiElementInterface> dimensionElements = this.makeDimensionElements();
        int dimensionElementsOffset = dimensionElements.size() >= 9 ? 0 : 9;
        for (int i = 0; i < dimensionElements.size(); ++i) {
            this.setSlot(9 + dimensionElementsOffset + i, dimensionElements.get(i));
        }
        List<GuiElementInterface> fileSystemElements = this.makeFileSystemElements();
        for (int i = 0; i < fileSystemElements.size(); ++i) {
            this.setSlot(27 + i, fileSystemElements.get(i));
        }
        List<GuiElementInterface> memoryElements = this.makeMemoryElements();
        for (int i = 0; i < memoryElements.size(); ++i) {
            this.setSlot(36 + i, memoryElements.get(i));
        }
        List<GuiElementInterface> gcElements = this.makeGcElements();
        for (int i = 0; i < gcElements.size(); ++i) {
            this.setSlot(45 + i, gcElements.get(i));
        }
    }

    private List<GuiElementInterface> makeDimensionElements() {
        ArrayList<GuiElementInterface> elements = new ArrayList<GuiElementInterface>();
        for (class_3218 world : WorldHelper.getWorlds()) {
            ArrayList<class_2561> lore = new ArrayList<class_2561>();
            lore.add(TextHelper.getTextByKey(this.getPlayer(), "profiler.dimension.name", RegistryHelper.getIdAsString((class_1937)world)));
            int blockEntityCount = 0;
            for (class_3193 chunk : WorldHelper.getChunks(world)) {
                class_2818 worldChunk = chunk.method_16144();
                if (worldChunk == null) continue;
                blockEntityCount += worldChunk.method_12214().size();
            }
            lore.add(TextHelper.getTextByKey(this.getPlayer(), "profiler.dimension.block_entities", blockEntityCount));
            class_1948.class_5262 spawnInfo = world.method_14178().method_27908();
            if (spawnInfo != null) {
                spawnInfo.method_27830().forEach((k, v) -> {
                    String groupName = k.method_6133();
                    int groupCount = v;
                    int groupCapacity = k.method_6134() * spawnInfo.method_27823() / CHUNK_AREA;
                    lore.add(TextHelper.getTextByKey(this.getPlayer(), "profiler.dimension.entity_group", groupName, groupCount, groupCapacity));
                });
            }
            GuiElement element = new GuiElementBuilder().setItem(WorldHelper.toGuiItem(RegistryHelper.getIdAsString((class_1937)world))).setName(TextHelper.getTextByKey(this.getPlayer(), "profiler.dimension", new Object[0])).setLore(lore).build();
            elements.add((GuiElementInterface)element);
        }
        return elements;
    }

    private GuiElementInterface makeOperatingSystemElement() {
        String osName = ManagementFactory.getOperatingSystemMXBean().getName();
        String osVersion = ManagementFactory.getOperatingSystemMXBean().getVersion();
        String osArch = ManagementFactory.getOperatingSystemMXBean().getArch();
        return new GuiElementBuilder().setItem(class_1802.field_8828).setName(TextHelper.getTextByKey(this.getPlayer(), "profiler.os", new Object[0])).setLore(List.of(TextHelper.getTextByKey(this.getPlayer(), "profiler.os.name", osName), TextHelper.getTextByKey(this.getPlayer(), "profiler.os.version", osVersion), TextHelper.getTextByKey(this.getPlayer(), "profiler.os.arch", osArch))).build();
    }

    private GuiElementInterface makeVirtualMachineElement() {
        String vmName = ManagementFactory.getRuntimeMXBean().getVmName();
        String vmVersion = ManagementFactory.getRuntimeMXBean().getVmVersion();
        return new GuiElementBuilder().setItem(class_1802.field_21086).setName(TextHelper.getTextByKey(this.getPlayer(), "profiler.vm", new Object[0])).setLore(List.of(TextHelper.getTextByKey(this.getPlayer(), "profiler.vm.name", vmName), TextHelper.getTextByKey(this.getPlayer(), "profiler.vm.version", vmVersion))).build();
    }

    private GuiElementInterface makeTpsElement() {
        return new GuiElementBuilder().setItem(class_1802.field_8557).setName(TextHelper.getTextByKey(this.getPlayer(), "profiler.tps", new Object[0])).setLore(List.of(TextHelper.getTextByKey(this.getPlayer(), "profiler.tps.description", new Object[0]), TextHelper.getTextByKey(this.getPlayer(), "profiler.tps.avg.5s", new Object[0]), TextHelper.getTextByKey(this.getPlayer(), "profiler.tps.avg.10s", new Object[0]), TextHelper.getTextByKey(this.getPlayer(), "profiler.tps.avg.1m", new Object[0]), TextHelper.getTextByKey(this.getPlayer(), "profiler.tps.avg.5m", new Object[0]), TextHelper.getTextByKey(this.getPlayer(), "profiler.tps.avg.15m", new Object[0]))).build();
    }

    private GuiElementInterface makeMsptElement() {
        return new GuiElementBuilder().setItem(class_1802.field_8557).setName(TextHelper.getTextByKey(this.getPlayer(), "profiler.mspt", new Object[0])).setLore(List.of(TextHelper.getTextByKey(this.getPlayer(), "profiler.mspt.description", new Object[0]), TextHelper.getTextByKey(this.getPlayer(), "profiler.mspt.summary.10s", new Object[0]), TextHelper.getTextByKey(this.getPlayer(), "profiler.mspt.summary.1m", new Object[0]))).build();
    }

    private GuiElementInterface makeCpuElement() {
        return new GuiElementBuilder().setItem(class_1802.field_8857).setName(TextHelper.getTextByKey(this.getPlayer(), "profiler.cpu", new Object[0])).setLore(List.of(TextHelper.getTextByKey(this.getPlayer(), "profiler.cpu.description", new Object[0]), TextHelper.getTextByKey(this.getPlayer(), "profiler.cpu.usage.system", new Object[0]), TextHelper.getTextByKey(this.getPlayer(), "profiler.cpu.usage.user", new Object[0]))).build();
    }

    private List<GuiElementInterface> makeFileSystemElements() {
        ArrayList<GuiElementInterface> elements = new ArrayList<GuiElementInterface>();
        List<FileStore> fileStores = new ArrayList();
        for (FileStore fileStore : FileSystems.getDefault().getFileStores()) {
            try {
                if (fileStore.getTotalSpace() == 0L || ProfilerInitializer.config.model().fileSystem.blacklisted_filesystem.stream().anyMatch(nameRegex -> fileStore.toString().matches((String)nameRegex))) continue;
                fileStores.add(fileStore);
            }
            catch (Exception exception) {}
        }
        fileStores = fileStores.stream().sorted((a, b) -> {
            try {
                long aUsed = a.getTotalSpace() - a.getUsableSpace();
                long bUsed = b.getTotalSpace() - b.getUsableSpace();
                return Long.compare(bUsed, aUsed);
            }
            catch (Exception exception) {
                return 0;
            }
        }).toList();
        for (FileStore fileStore : fileStores) {
            try {
                long maxSpace = fileStore.getTotalSpace();
                long usedSpace = fileStore.getTotalSpace() - fileStore.getUsableSpace();
                double usagePercent = (double)usedSpace / (double)maxSpace;
                GuiElementBuilder builder = new GuiElementBuilder().setItem(class_1802.field_8536).setName(TextHelper.getTextByKey(this.getPlayer(), "profiler.fs", new Object[0])).setLore(List.of(TextHelper.getTextByKey(this.getPlayer(), "profiler.fs.name", fileStore), TextHelper.getTextByKey(this.getPlayer(), "profiler.fs.type", fileStore.type()), TextHelper.getTextByKey(this.getPlayer(), "profiler.fs.max", StringUtil.formatBytes(maxSpace)), TextHelper.getTextByKey(this.getPlayer(), "profiler.fs.used", StringUtil.formatBytes(usedSpace)), TextHelper.getTextByKey(this.getPlayer(), "profiler.fs.usage", usagePercent)));
                elements.add((GuiElementInterface)builder.build());
            }
            catch (Exception exception) {}
        }
        return elements;
    }

    private List<GuiElementInterface> makeMemoryElements() {
        ArrayList<GuiElementInterface> elements = new ArrayList<GuiElementInterface>();
        List<MemoryPoolMXBean> memoryPoolMXBeans = ManagementFactory.getMemoryPoolMXBeans();
        memoryPoolMXBeans.sort((a, b) -> {
            if (a.getType() == MemoryType.HEAP && b.getType() != MemoryType.HEAP) {
                return -1;
            }
            if (b.getType() == MemoryType.HEAP && a.getType() != MemoryType.HEAP) {
                return 1;
            }
            if (a.getUsage().getUsed() > b.getUsage().getUsed()) {
                return -1;
            }
            if (b.getUsage().getUsed() > a.getUsage().getUsed()) {
                return 1;
            }
            return 0;
        });
        for (MemoryPoolMXBean memoryPoolMXBean : memoryPoolMXBeans) {
            String memoryName = memoryPoolMXBean.getName();
            MemoryType memoryType = memoryPoolMXBean.getType();
            MemoryUsage memoryUsage = memoryPoolMXBean.getUsage();
            String init = StringUtil.formatBytes(memoryUsage.getInit());
            String used = StringUtil.formatBytes(memoryUsage.getUsed());
            String committed = StringUtil.formatBytes(memoryUsage.getCommitted());
            String max = StringUtil.formatBytes(memoryUsage.getMax());
            class_1792 item = memoryType == MemoryType.HEAP ? class_1802.field_8598 : class_1802.field_8529;
            GuiElementBuilder guiElementBuilder = new GuiElementBuilder().setItem(item).setName(TextHelper.getTextByKey(this.getPlayer(), "profiler.memory", new Object[0])).setLore(List.of(TextHelper.getTextByKey(this.getPlayer(), "profiler.memory.name", memoryName), TextHelper.getTextByKey(this.getPlayer(), "profiler.memory.type", new Object[]{memoryType}), TextHelper.getTextByKey(this.getPlayer(), "profiler.memory.init", init), TextHelper.getTextByKey(this.getPlayer(), "profiler.memory.used", used), TextHelper.getTextByKey(this.getPlayer(), "profiler.memory.committed", committed), TextHelper.getTextByKey(this.getPlayer(), "profiler.memory.max", max)));
            elements.add((GuiElementInterface)guiElementBuilder.build());
        }
        return elements;
    }

    private List<GuiElementInterface> makeGcElements() {
        ArrayList<GuiElementInterface> elements = new ArrayList<GuiElementInterface>();
        List<GarbageCollectorMXBean> gcMXBeans = ManagementFactory.getGarbageCollectorMXBeans();
        long uptime = ManagementFactory.getRuntimeMXBean().getUptime();
        for (GarbageCollectorMXBean gcMXBean : gcMXBeans) {
            String name = gcMXBean.getName();
            long totalGcTime = gcMXBean.getCollectionTime();
            long totalGcCount = gcMXBean.getCollectionCount();
            double avgFrequency = (double)uptime / (double)totalGcCount / 1000.0;
            double avgTime = (double)totalGcTime / (double)totalGcCount;
            GuiElement element = new GuiElementBuilder().setItem(class_1802.field_17346).setName(TextHelper.getTextByKey(this.getPlayer(), "profiler.gc", new Object[0])).setLore(List.of(TextHelper.getTextByKey(this.getPlayer(), "profiler.gc.name", name), TextHelper.getTextByKey(this.getPlayer(), "profiler.gc.average_gc_time", avgTime), TextHelper.getTextByKey(this.getPlayer(), "profiler.gc.total_gc_time", totalGcTime), TextHelper.getTextByKey(this.getPlayer(), "profiler.gc.average_frequency", avgFrequency), TextHelper.getTextByKey(this.getPlayer(), "profiler.gc.total_gc_count", totalGcCount))).build();
            elements.add((GuiElementInterface)element);
        }
        return elements;
    }
}

