/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.rank.service;

import io.github.sakurawald.fuji.core.auxiliary.minecraft.CommandHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.LuckpermsHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.PlayerHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.command.executor.CommandExecutor;
import io.github.sakurawald.fuji.core.command.executor.structure.ExtendedCommandSource;
import io.github.sakurawald.fuji.core.document.annotation.DocStringProvider;
import io.github.sakurawald.fuji.core.document.descriptor.PermissionDescriptor;
import io.github.sakurawald.fuji.core.manager.Managers;
import io.github.sakurawald.fuji.module.initializer.rank.RankInitializer;
import io.github.sakurawald.fuji.module.initializer.rank.structure.RankDataNode;
import io.github.sakurawald.fuji.module.initializer.rank.structure.RankNode;
import io.github.sakurawald.fuji.module.initializer.rank.structure.RankRequirement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RankService {
    @DocStringProvider(id=1754414038512L, value="The `starting rank node` is allowed to be selected for this `player`, if they have no rank yet.\nYou can assign multiple `starting rank nodes` to be selected.\n")
    private static final PermissionDescriptor RANK_STARTING_RANK_NODE_PERMISSION_DESCRIPTOR = new PermissionDescriptor("fuji.rank.starting_rank_node.<rank-node-id>", 1754414038512L);
    private static final Map<RankNode, List<RankNode>> PREVIOUS_RANK_NODES_MAP = new HashMap<RankNode, List<RankNode>>();
    private static final Map<RankNode, List<RankNode>> NEXT_RANK_NODES_MAP = new HashMap<RankNode, List<RankNode>>();

    public static List<RankNode> getAllRankNodes() {
        return RankInitializer.config.model().getGraph().stream().filter(RankNode::isEnable).toList();
    }

    public static List<String> getAllRankIds() {
        return RankService.getAllRankNodes().stream().map(RankNode::getId).toList();
    }

    public static Optional<RankNode> findRankNode(@Nullable String id) {
        return RankService.getAllRankNodes().stream().filter(it -> it.getId().equals(id)).findFirst();
    }

    public static Optional<RankNode> getStartingRankNode() {
        String startingRankNodeId = RankInitializer.config.model().getStartingRankNodeId();
        return RankService.findRankNode(startingRankNodeId);
    }

    public static List<RankNode> getAvailableStartingRankNodes(@Nullable class_3222 player) {
        ArrayList<RankNode> result = new ArrayList<RankNode>();
        if (player != null) {
            List<RankNode> A = RankService.getAllRankNodes().stream().filter(it -> LuckpermsHelper.hasPermission(player.method_5667(), RANK_STARTING_RANK_NODE_PERMISSION_DESCRIPTOR, it.getId())).toList();
            result.addAll(A);
        }
        RankService.getStartingRankNode().ifPresent(result::add);
        return result;
    }

    public static boolean canMoveTo(@NotNull class_3222 player, @NotNull RankNode rankNode) {
        ExtendedCommandSource source = ExtendedCommandSource.asConsole(player.method_5671());
        boolean canMoveTo = rankNode.getRequirements().stream().allMatch(rankRequirement -> RankService.isRankRequirementMet(rankRequirement, source));
        return canMoveTo;
    }

    public static boolean isRankRequirementMet(RankRequirement rankRequirement, ExtendedCommandSource source) {
        return rankRequirement.getCommands().stream().allMatch(command -> CommandHelper.Return.isSuccess(CommandExecutor.executeSingle(source, command)));
    }

    public static void tryMoveTo(@NotNull class_3222 player, @Nullable RankNode newRankNode) {
        if (newRankNode != null) {
            if (RankService.canMoveTo(player, newRankNode)) {
                RankService.moveTo(player, newRankNode);
                TextHelper.sendTextByKey(player, "rank.up", newRankNode.getDisplayName());
            } else {
                TextHelper.sendTextByKey(player, "rank.up.requirements_not_meet", newRankNode.getDisplayName());
                RankService.sendRankNodeRequirements(player.method_5671(), newRankNode);
            }
        } else {
            RankService.moveTo(player, null);
        }
    }

    public static void moveTo(@NotNull class_3222 player, @Nullable RankNode newRankNode) {
        ExtendedCommandSource source = ExtendedCommandSource.asConsole(player.method_5671());
        Optional<RankNode> previousRankNode = RankService.getCurrentRankNode(player);
        previousRankNode.ifPresent(it -> CommandExecutor.executeBatch(source, it.getEvents().getOnLeaveThisRankNodeCommands()));
        RankService.withRankDataNode(player, true, rankDataNode -> {
            String newValue = newRankNode == null ? null : newRankNode.getId();
            rankDataNode.setCurrentRankNodeId(newValue);
            if (newRankNode != null) {
                CommandExecutor.executeBatch(source, newRankNode.getEvents().getOnEnterThisRankNodeCommands());
                if (!rankDataNode.getWalkedRankNodeIds().contains(newValue)) {
                    CommandExecutor.executeBatch(source, newRankNode.getEvents().getOnFirstEnterThisRankNodeCommands());
                }
                rankDataNode.getWalkedRankNodeIds().add(newRankNode.getId());
            }
            return null;
        });
    }

    public static Optional<RankNode> getCurrentRankNode(@NotNull class_3222 player) {
        return RankService.withRankDataNode(player, false, rankDataNode -> {
            @Nullable String currentRankNodeId = rankDataNode.getCurrentRankNodeId();
            return RankService.findRankNode(currentRankNodeId);
        });
    }

    private static <T> T withRankDataNode(@NotNull class_3222 player, boolean writeStorage, Function<RankDataNode, T> function) {
        String playerName = PlayerHelper.getPlayerName((class_1657)player);
        RankDataNode rankDataNode = RankInitializer.data.model().getRankDataNodeMap().computeIfAbsent(playerName, key -> RankDataNode.make());
        T apply = function.apply(rankDataNode);
        if (writeStorage) {
            RankInitializer.data.writeStorage();
        }
        return apply;
    }

    public static class_2561 getNoRankStatusText() {
        return TextHelper.getTextByValue(null, RankInitializer.config.model().getNoRankStatusText(), new Object[0]);
    }

    public static List<RankNode> getNextAvailableRankNodes(@NotNull class_3222 player) {
        return RankService.getNextAvailableRankNodes(player, RankService.getCurrentRankNode(player));
    }

    @NotNull
    public static List<RankNode> getNextAvailableRankNodes(@Nullable class_3222 player, Optional<RankNode> currentRankNode) {
        return currentRankNode.map(NEXT_RANK_NODES_MAP::get).orElseGet(() -> RankService.getAvailableStartingRankNodes(player));
    }

    public static List<RankNode> getPreviousAvailableRankNodes(@NotNull class_3222 player) {
        return RankService.getCurrentRankNode(player).map(currentRankNode -> {
            Set<String> walkedRankNodeIds = RankService.getWalkedRankNodeIds(player);
            return PREVIOUS_RANK_NODES_MAP.get(currentRankNode).stream().filter(it -> walkedRankNodeIds.contains(it.getId())).toList();
        }).orElseGet(List::of);
    }

    public static Set<String> getWalkedRankNodeIds(@NotNull class_3222 player) {
        return RankService.withRankDataNode(player, false, RankDataNode::getWalkedRankNodeIds);
    }

    public static void computeRankGraph() {
        NEXT_RANK_NODES_MAP.clear();
        PREVIOUS_RANK_NODES_MAP.clear();
        RankService.getAllRankNodes().forEach(it -> {
            List<RankNode> nextRankNodes = RankService.computeNextRankNodes(it);
            NEXT_RANK_NODES_MAP.put((RankNode)it, nextRankNodes);
            nextRankNodes.forEach(nextRankNode -> PREVIOUS_RANK_NODES_MAP.computeIfAbsent((RankNode)nextRankNode, k -> new ArrayList()).add(it));
            PREVIOUS_RANK_NODES_MAP.computeIfAbsent((RankNode)it, k -> new ArrayList());
        });
    }

    @NotNull
    private static List<RankNode> computeNextRankNodes(@NotNull RankNode it) {
        return it.getNextRankNodes().stream().map(id -> RankService.findRankNode(id).orElse(null)).filter(Objects::nonNull).toList();
    }

    public static void sendRankNodeInfo(@NotNull class_2168 source, @NotNull RankNode rankNode, boolean displayRequirements) {
        List<RankNode> nextRankNodes;
        TextHelper.sendTextByKey(source, "rank.info.header", new Object[0]);
        TextHelper.sendTextByKey(source, "rank.rank_node.id", rankNode.getId());
        TextHelper.sendTextByKey(source, "rank.rank_node.display_name", rankNode.getDisplayName());
        TextHelper.sendTextByKey(source, "rank.rank_node.description", rankNode.getDescription());
        List<String> nextRankNodeIds = rankNode.getNextRankNodes();
        if (nextRankNodeIds.isEmpty()) {
            TextHelper.sendTextByKey(source, "rank.rank_node.next_nodes", TextHelper.Operators.getString(RankService.getNoRankStatusText()));
        } else {
            TextHelper.sendTextByKey(source, "rank.rank_node.next_nodes", nextRankNodeIds.toString());
        }
        if (displayRequirements) {
            RankService.sendRankNodeRequirements(source, rankNode);
        }
        if (!(nextRankNodes = RankService.getNextAvailableRankNodes(null, Optional.of(rankNode))).isEmpty()) {
            TextHelper.sendTextByKey(source, "rank.info.next_ranks", new Object[0]);
            class_5250 textBuilder = class_2561.method_43473();
            nextRankNodes.forEach(nextRankNode -> {
                String value = "<grey>[</grey>%s<grey>]</grey>".formatted(nextRankNode.getDisplayName());
                class_5250 singleText = TextHelper.getTextByValue(source, value, new Object[0]).method_27661();
                class_2558 clickEvent = Managers.getCallbackManager().makeCallbackEvent(player -> RankService.sendRankNodeInfo(source, nextRankNode, true), 5L, TimeUnit.MINUTES);
                class_2561 hoverText = TextHelper.getTextByKey(source, "prompt.click.see_it.any", new Object[0]);
                singleText.method_27696(class_2583.field_24360.method_10958(clickEvent).method_10949(TextHelper.Events.HoverEvent.makeShowTextAction(hoverText)));
                textBuilder.method_10852((class_2561)singleText);
                textBuilder.method_10852(TextHelper.TEXT_SPACE);
            });
            TextHelper.sendMessageByText(source, (class_2561)textBuilder);
        } else {
            TextHelper.sendTextByKey(source, "rank.info.no_next_rank", rankNode.getDisplayName());
        }
    }

    public static void sendRankNodeRequirements(@NotNull class_2168 source, @NotNull RankNode rankNode) {
        TextHelper.sendTextByKey(source, "rank.rank_node.requirements", new Object[0]);
        List<RankRequirement> requirements = rankNode.getRequirements();
        if (requirements.isEmpty()) {
            TextHelper.sendTextByKey(source, "rank.rank_node.requirements.empty", new Object[0]);
        } else {
            requirements.forEach(rankRequirement -> {
                ExtendedCommandSource extendedCommandSource = ExtendedCommandSource.asConsole(source);
                boolean rankRequirementMet = RankService.isRankRequirementMet(rankRequirement, extendedCommandSource);
                String languageKey = rankRequirementMet ? "checkbox.true" : "checkbox.false";
                TextHelper.sendTextByKey(source, languageKey, rankRequirement.getDescription());
            });
        }
    }
}

