/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.top_chunks.service;

import io.github.sakurawald.fuji.core.auxiliary.minecraft.PlayerHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.WorldHelper;
import io.github.sakurawald.fuji.module.initializer.top_chunks.TopChunksInitializer;
import io.github.sakurawald.fuji.module.initializer.top_chunks.config.model.TopChunksConfigModel;
import io.github.sakurawald.fuji.module.initializer.top_chunks.structure.ChunkScore;
import java.util.HashMap;
import java.util.List;
import java.util.PriorityQueue;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2818;
import net.minecraft.class_3193;
import net.minecraft.class_3218;
import org.jetbrains.annotations.NotNull;

public class TopChunksService {
    public static List<ChunkScore> trimChunkScoreList(List<ChunkScore> chunkScores) {
        int begin = 0;
        int end = Math.min(chunkScores.size(), TopChunksService.getMaxDisplayChunkScore());
        return chunkScores.subList(begin, end);
    }

    @NotNull
    public static PriorityQueue<ChunkScore> computeChunkScores(class_2168 source) {
        PriorityQueue<ChunkScore> PQ = new PriorityQueue<ChunkScore>();
        for (class_3218 world : WorldHelper.getWorlds()) {
            HashMap<class_1923, ChunkScore> topChunkReport = new HashMap<class_1923, ChunkScore>();
            for (class_1297 entity : world.method_27909()) {
                class_1923 pos = entity.method_31476();
                topChunkReport.putIfAbsent(pos, new ChunkScore(world, pos));
                ((ChunkScore)topChunkReport.get(pos)).plusEntity(entity);
            }
            for (class_3193 chunkHolder : WorldHelper.getChunks(world)) {
                class_2818 worldChunk = chunkHolder.method_16144();
                if (worldChunk == null) continue;
                for (class_2586 blockEntity : worldChunk.method_12214().values()) {
                    class_1923 pos = worldChunk.method_12004();
                    topChunkReport.putIfAbsent(pos, new ChunkScore(world, pos));
                    ((ChunkScore)topChunkReport.get(pos)).plusBlockEntity(blockEntity);
                }
            }
            topChunkReport.values().forEach(chunkScore -> {
                chunkScore.sum();
                PQ.add((ChunkScore)chunkScore);
            });
        }
        TopChunksService.attachNearestPlayerIntoChunkScore(source, PQ, TopChunksService.getMaxDisplayChunkScore());
        return PQ;
    }

    private static void attachNearestPlayerIntoChunkScore(class_2168 source, @NotNull PriorityQueue<ChunkScore> PQ, int topN) {
        int count = 0;
        for (ChunkScore chunkScore : PQ) {
            class_1923 chunkPos;
            class_2338 blockPos;
            if (count++ >= topN) break;
            class_3218 world = chunkScore.getDimension();
            class_1657 nearestPlayer = world.method_18459((double)(blockPos = (chunkPos = chunkScore.getChunkPos()).method_8323()).method_10263(), (double)blockPos.method_10264(), (double)blockPos.method_10260(), (double)TopChunksInitializer.config.model().distanceToSearchNearestPlayer, false);
            if (nearestPlayer == null) continue;
            String nearestPlayerName = PlayerHelper.getPlayerName(nearestPlayer);
            String nearestPlayerString = TextHelper.Operators.getString(TextHelper.getTextByKey(source, "top_chunks.prop.players.nearest", nearestPlayerName));
            chunkScore.getPlayers().add(nearestPlayerString);
        }
    }

    private static int getMaxDisplayChunkScore() {
        TopChunksConfigModel.Top top = TopChunksInitializer.config.model().top;
        return top.rows * top.columns;
    }
}

