/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.top_chunks.structure;

import io.github.sakurawald.fuji.core.auxiliary.minecraft.CommandHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.LuckpermsHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.PlayerHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.RegistryHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.document.annotation.DocStringProvider;
import io.github.sakurawald.fuji.core.document.descriptor.PermissionDescriptor;
import io.github.sakurawald.fuji.core.manager.Managers;
import io.github.sakurawald.fuji.core.service.type_formatter.TypeFormatter;
import io.github.sakurawald.fuji.core.structure.GlobalPos;
import io.github.sakurawald.fuji.module.initializer.top_chunks.TopChunksInitializer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2586;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChunkScore
implements Comparable<ChunkScore> {
    @DocStringProvider(id=1752000233472L, value="Click to teleport to the chunk location.\n")
    private static final PermissionDescriptor CLICK_TO_TELEPORT_TO_CHUNK_LOCATION_PERMISSION = new PermissionDescriptor("top_chunks.teleport", 1752000233472L);
    private final class_3218 dimension;
    private final class_1923 chunkPos;
    private final Map<String, Integer> type2amount = new HashMap<String, Integer>();
    private int score;
    private final Set<String> players = new HashSet<String>();

    public ChunkScore(class_3218 dimension, class_1923 chunkPos) {
        this.dimension = dimension;
        this.chunkPos = chunkPos;
    }

    public static boolean canClickToTeleportToThisChunk(@Nullable class_3222 player) {
        if (player == null) {
            return false;
        }
        return CommandHelper.Requirement.isOperator((class_1657)player) || LuckpermsHelper.hasPermission(player.method_5667(), CLICK_TO_TELEPORT_TO_CHUNK_LOCATION_PERMISSION, new Object[0]);
    }

    public void plusEntity(@NotNull class_1297 entity) {
        String type = entity.method_5864().method_5882();
        this.type2amount.putIfAbsent(type, 0);
        this.type2amount.put(type, this.type2amount.get(type) + 1);
        if (entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            this.players.add(PlayerHelper.getPlayerName((class_1657)player));
        }
    }

    public void plusBlockEntity(@NotNull class_2586 blockEntity) {
        String type = blockEntity.method_11010().method_26204().method_9539();
        this.type2amount.putIfAbsent(type, 0);
        this.type2amount.put(type, this.type2amount.get(type) + 1);
    }

    public void sum() {
        this.score = 0;
        for (String type : this.type2amount.keySet()) {
            HashMap<String, Integer> type2score = TopChunksInitializer.config.model().type2score;
            this.score += type2score.getOrDefault(type, type2score.get("default")) * this.type2amount.get(type);
        }
    }

    @NotNull
    public String toString() {
        return String.format("%-5d", this.score);
    }

    @Override
    public int compareTo(@NotNull ChunkScore that) {
        return Integer.compare(that.score, this.score);
    }

    @NotNull
    public class_2561 toText(@NotNull class_2168 source) {
        class_5250 hoverText = class_2561.method_43473().method_27692(class_124.field_1065).method_10852(TextHelper.getTextByKey(source, "top_chunks.prop.dimension", RegistryHelper.getIdAsString((class_1937)this.dimension))).method_10852(TextHelper.TEXT_NEWLINE).method_10852(this.computeChunkLocationText(source)).method_10852(TextHelper.TEXT_NEWLINE).method_10852(TextHelper.getTextByKey(source, "top_chunks.prop.score", this.score)).method_10852(TextHelper.TEXT_NEWLINE).method_10852(TextHelper.getTextByKey(source, "top_chunks.prop.players", this.players)).method_10852(TextHelper.TEXT_NEWLINE).method_10852(TypeFormatter.formatTypes(source, this.type2amount));
        class_2583 chunkScoreTextStyle = class_2583.field_24360.method_10949(TextHelper.Events.HoverEvent.makeShowTextAction((class_2561)hoverText)).method_27706(this.players.isEmpty() ? class_124.field_1080 : class_124.field_1077);
        if (ChunkScore.canClickToTeleportToThisChunk(source.method_44023())) {
            hoverText.method_10852(TextHelper.TEXT_NEWLINE);
            hoverText.method_10852(TextHelper.getTextByKey(source, "prompt.click.teleport", new Object[0]));
            class_2558 clickEvent = Managers.getCallbackManager().makeCallbackEvent(this::teleportToThisChunk, 5L, TimeUnit.MINUTES);
            chunkScoreTextStyle = chunkScoreTextStyle.method_10958(clickEvent);
        }
        class_5250 chunkScoreText = class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)this.toString())).method_27696(chunkScoreTextStyle);
        return chunkScoreText;
    }

    public class_2561 computeChunkLocationText(@NotNull class_2168 source) {
        if (TopChunksInitializer.config.model().hide_location) {
            if (CommandHelper.Requirement.isAdmin(source)) {
                return TextHelper.getTextByKey(source, "top_chunks.prop.chunk.hide_location.bypass", this.chunkPos.toString());
            }
            return TextHelper.getTextByKey(source, "top_chunks.prop.chunk.hide_location", new Object[0]);
        }
        return TextHelper.getTextByKey(source, "top_chunks.prop.chunk.display_location", this.chunkPos.toString());
    }

    public void teleportToThisChunk(class_3222 player) {
        class_2338 chunkCenterPos = new class_2338(this.chunkPos.method_33940(), 128, this.chunkPos.method_33942());
        int y = this.dimension.method_8598(class_2902.class_2903.field_13197, chunkCenterPos).method_10264();
        if (y == -64) {
            y = 128;
        }
        new GlobalPos((class_1937)this.dimension, (double)chunkCenterPos.method_10263(), (double)y, (double)chunkCenterPos.method_10260(), player.method_36454(), player.method_36455()).teleport(player);
    }

    @Generated
    public class_3218 getDimension() {
        return this.dimension;
    }

    @Generated
    public class_1923 getChunkPos() {
        return this.chunkPos;
    }

    @Generated
    public Map<String, Integer> getType2amount() {
        return this.type2amount;
    }

    @Generated
    public int getScore() {
        return this.score;
    }

    @Generated
    public Set<String> getPlayers() {
        return this.players;
    }

    @Generated
    public ChunkScore setScore(int score) {
        this.score = score;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChunkScore)) {
            return false;
        }
        ChunkScore other = (ChunkScore)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getScore() != other.getScore()) {
            return false;
        }
        class_3218 this$dimension = this.getDimension();
        class_3218 other$dimension = other.getDimension();
        if (this$dimension == null ? other$dimension != null : !this$dimension.equals(other$dimension)) {
            return false;
        }
        class_1923 this$chunkPos = this.getChunkPos();
        class_1923 other$chunkPos = other.getChunkPos();
        if (this$chunkPos == null ? other$chunkPos != null : !this$chunkPos.equals(other$chunkPos)) {
            return false;
        }
        Map<String, Integer> this$type2amount = this.getType2amount();
        Map<String, Integer> other$type2amount = other.getType2amount();
        if (this$type2amount == null ? other$type2amount != null : !((Object)this$type2amount).equals(other$type2amount)) {
            return false;
        }
        Set<String> this$players = this.getPlayers();
        Set<String> other$players = other.getPlayers();
        return !(this$players == null ? other$players != null : !((Object)this$players).equals(other$players));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ChunkScore;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getScore();
        class_3218 $dimension = this.getDimension();
        result = result * 59 + ($dimension == null ? 43 : $dimension.hashCode());
        class_1923 $chunkPos = this.getChunkPos();
        result = result * 59 + ($chunkPos == null ? 43 : $chunkPos.hashCode());
        Map<String, Integer> $type2amount = this.getType2amount();
        result = result * 59 + ($type2amount == null ? 43 : ((Object)$type2amount).hashCode());
        Set<String> $players = this.getPlayers();
        result = result * 59 + ($players == null ? 43 : ((Object)$players).hashCode());
        return result;
    }
}

