/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.warning.service;

import io.github.sakurawald.fuji.core.auxiliary.ChronosUtil;
import io.github.sakurawald.fuji.core.auxiliary.LogUtil;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.LuckpermsHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.PlayerHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.command.executor.CommandExecutor;
import io.github.sakurawald.fuji.core.command.executor.structure.ExtendedCommandSource;
import io.github.sakurawald.fuji.core.service.paged_text.PagedMessageText;
import io.github.sakurawald.fuji.module.initializer.warning.WarningInitializer;
import io.github.sakurawald.fuji.module.initializer.warning.config.model.WarningConfigModel;
import io.github.sakurawald.fuji.module.initializer.warning.structure.PlayerWarnings;
import io.github.sakurawald.fuji.module.initializer.warning.structure.Warning;
import io.github.sakurawald.fuji.module.initializer.warning.structure.WarningRule;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WarningService {
    @NotNull
    public static PlayerWarnings getPlayerWarnings(@NotNull String playerName) {
        List<PlayerWarnings> players = WarningInitializer.data.model().players;
        Optional<PlayerWarnings> playerWarnings = players.stream().filter(it -> it.getPlayer().equals(playerName)).findFirst();
        return playerWarnings.orElseGet(() -> {
            PlayerWarnings newValue = PlayerWarnings.make(playerName);
            players.add(newValue);
            WarningInitializer.data.writeStorage();
            return newValue;
        });
    }

    public static void createWarning(@NotNull String creatorName, @NotNull String targetPlayerName, @NotNull String warningDescription, @Nullable Long expirationTimestamp) {
        Warning newWarning = Warning.make(creatorName, warningDescription, expirationTimestamp);
        WarningService.getPlayerWarnings(targetPlayerName).getWarnings().add(newWarning);
        WarningInitializer.data.writeStorage();
        if (expirationTimestamp != null) {
            WarningService.processTemporalWarningRules(targetPlayerName);
        } else {
            WarningService.processPermanentWarningRules(targetPlayerName);
        }
    }

    public static void deleteWarning(@NotNull String targetPlayerName, @NotNull Warning warning) {
        WarningService.getPlayerWarnings(targetPlayerName).getWarnings().remove(warning);
        WarningInitializer.data.writeStorage();
    }

    public static int clearWarnings(@NotNull String targetPlayerName) {
        List<Warning> warnings = WarningService.getPlayerWarnings(targetPlayerName).getWarnings();
        int originalSize = warnings.size();
        warnings.clear();
        WarningInitializer.data.writeStorage();
        return originalSize;
    }

    public static void clearAllWarnings() {
        WarningInitializer.data.model().players = new ArrayList<PlayerWarnings>();
        WarningInitializer.data.writeStorage();
    }

    public static void processNotify(@NotNull class_3222 targetPlayer, boolean isJoin) {
        String playerName = PlayerHelper.getPlayerName((class_1657)targetPlayer);
        List<Warning> activeWarnings = WarningService.getPlayerWarnings(playerName).getWarnings().stream().filter(Warning::isActive).toList();
        if (activeWarnings.isEmpty()) {
            return;
        }
        PlayerHelper.Lookup.getOnlinePlayers().stream().filter(it -> LuckpermsHelper.hasPermission(it.method_5667(), WarningInitializer.NOTIFY_WARNINGS_PERMISSION, new Object[0])).forEach(it -> {
            int activeWarningsSize = activeWarnings.size();
            if (isJoin) {
                TextHelper.sendTextByKey(it, "warning.notify.join", playerName, activeWarningsSize);
            } else {
                TextHelper.sendTextByKey(it, "warning.notify.leave", playerName, activeWarningsSize);
            }
        });
    }

    private static void processPermanentWarningRules(@NotNull String targetPlayerName) {
        WarningService.processWarningRules(targetPlayerName, WarningInitializer.config.model().getOnPermanentWarningCreated(), Warning::isPermanentWarning);
    }

    private static void processTemporalWarningRules(@NotNull String targetPlayerName) {
        WarningService.processWarningRules(targetPlayerName, WarningInitializer.config.model().getOnTemporalWarningCreated(), Warning::isTemporalWarning);
    }

    private static void processWarningRules(@NotNull String targetPlayerName, @NotNull List<WarningRule> warningRules, @NotNull Predicate<Warning> warningTypeFilter) {
        Optional<WarningRule> first = warningRules.stream().sorted(Comparator.comparing(WarningRule::getIfNumberOfWarningsGreaterEqualThan).reversed()).filter(warningRule -> {
            int numberOfWarnings = WarningService.getPlayerWarnings(targetPlayerName).getWarnings().stream().filter(warning -> warningTypeFilter.test((Warning)warning) && warning.isActive()).toList().size();
            return numberOfWarnings >= warningRule.getIfNumberOfWarningsGreaterEqualThan();
        }).findFirst();
        if (first.isPresent()) {
            WarningRule warningRule2 = first.get();
            LogUtil.info("Execute the warning rule for player {}: warning rule = {}", targetPlayerName, warningRule2);
            class_2168 offlineServerCommandSource = PlayerHelper.Loader.loadDummyPlayer(targetPlayerName).method_5671();
            ExtendedCommandSource extendedCommandSource = ExtendedCommandSource.asConsole(offlineServerCommandSource);
            List<String> commands = warningRule2.getCommands();
            CommandExecutor.executeBatch(extendedCommandSource, commands);
        }
    }

    public static void processWarningReminder(@NotNull class_3222 targetPlayer) {
        WarningConfigModel.WarningReminder config = WarningInitializer.config.model().getWarningReminder();
        if (!config.isRemindWarnedPlayerOnJoinServer()) {
            return;
        }
        String playerName = PlayerHelper.getPlayerName((class_1657)targetPlayer);
        PlayerWarnings playerWarnings = WarningService.getPlayerWarnings(playerName);
        List<Warning> reminderSourceWarnings = playerWarnings.getWarnings().stream().filter(Warning::isActive).filter(it -> config.getReminderSource().isRemindPermanentWarningsType() && it.isPermanentWarning() || config.getReminderSource().isRemindTemporalWarningsType() && it.isTemporalWarning()).toList();
        if (reminderSourceWarnings.isEmpty()) {
            return;
        }
        TextHelper.sendTextByKey(targetPlayer, "warning.remind.header", new Object[0]);
        PagedMessageText pagedMessageText = PagedMessageText.makePagedMessageText(targetPlayer, reminderSourceWarnings, 1, (entity, index, builder) -> {
            String description = entity.getDescription();
            String createdDate = ChronosUtil.Formatter.formatDate(entity.getCreatedTimestamp());
            String expirationDate = ChronosUtil.Formatter.formatDate(entity.getExpirationTimestamp());
            class_2561 entityText = TextHelper.getTextByKey(targetPlayer, "warning.remind.entry", description, createdDate, expirationDate);
            builder.method_10852(entityText);
        });
        pagedMessageText.sendPage(targetPlayer, 0);
    }
}

