/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.works.job;

import io.github.sakurawald.fuji.core.annotation.Unused;
import io.github.sakurawald.fuji.core.document.annotation.Document;
import io.github.sakurawald.fuji.core.event.annotation.EventConsumer;
import io.github.sakurawald.fuji.core.event.message.server.lifecycle.ServerStartedEvent;
import io.github.sakurawald.fuji.core.job.abst.CronJob;
import io.github.sakurawald.fuji.core.job.interfaces.Schedulable;
import io.github.sakurawald.fuji.core.manager.Managers;
import io.github.sakurawald.fuji.module.initializer.works.structure.WorksBinding;
import java.util.HashSet;
import java.util.function.Supplier;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.quartz.JobExecutionContext;

@Document(id=1751825531415L, value="This `job` is used to dispatch the `onSchedule` event for each `work`.\n\nFor example:\n1. To end the sample of a `production work`.\n")
public class WorksOnScheduleDispatcherJob
extends CronJob {
    private WorksOnScheduleDispatcherJob(Supplier<String> cronSupplier) {
        super(null, cronSupplier);
    }

    public static WorksOnScheduleDispatcherJob makeInstance() {
        return new WorksOnScheduleDispatcherJob(() -> "0/5 * * ? * * *");
    }

    @EventConsumer
    private static void scheduleWorksOnScheduleDispatcherJob(@Unused ServerStartedEvent event) {
        WorksOnScheduleDispatcherJob job = WorksOnScheduleDispatcherJob.makeInstance();
        Managers.getScheduleManager().scheduleJob(job);
    }

    public void execute(@NotNull JobExecutionContext context) {
        HashSet uniqueWorks = new HashSet();
        WorksBinding.BLOCK_POS_2_WORKS.values().forEach(uniqueWorks::addAll);
        WorksBinding.ENTITY_2_WORKS.values().forEach(uniqueWorks::addAll);
        uniqueWorks.forEach(it -> {
            if (it instanceof Schedulable) {
                Schedulable schedulable = (Schedulable)((Object)it);
                schedulable.onSchedule();
            }
        });
    }

    @Generated
    public WorksOnScheduleDispatcherJob() {
    }
}

