/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.world.border;

import io.github.sakurawald.fuji.core.annotation.HotPath;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.PlayerHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.WorldHelper;
import io.github.sakurawald.fuji.core.config.handler.abst.BaseConfigurationHandler;
import io.github.sakurawald.fuji.core.config.handler.impl.ObjectConfigurationHandler;
import io.github.sakurawald.fuji.core.document.annotation.ColorBox;
import io.github.sakurawald.fuji.core.document.annotation.ColorBoxes;
import io.github.sakurawald.fuji.core.document.annotation.Document;
import io.github.sakurawald.fuji.core.document.annotation.TestCase;
import io.github.sakurawald.fuji.module.initializer.ModuleInitializer;
import io.github.sakurawald.fuji.module.initializer.world.border.config.model.WorldBorderConfigModel;
import io.github.sakurawald.fuji.module.initializer.world.border.structure.BorderDescriptor;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_1937;
import net.minecraft.class_2596;
import net.minecraft.class_2784;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_5895;
import net.minecraft.class_5896;
import net.minecraft.class_5897;
import net.minecraft.class_5898;
import net.minecraft.class_5899;

@Document(id=1752561532728L, value="This module allows you to customize the `per-dimension border`.\n")
@ColorBoxes(value={@ColorBox(id=1753064857726L, color=ColorBox.ColorBoxTypes.NOTE, value="\u25c9 How it works?\nIn internal Minecraft, each `dimension` has a function named `getWorldBorder()`.\nIt returns the `world border` of this `dimension`.\n\nThe vanilla Minecraft only returns the `world border` of `minecraft:overworld`.\nFuji modify the `getWorldBorder()` function, to let it return the `per-dimension border`.\n\n\u25c9 How can I configure the `per-dimension border`?\nYou can modify the config file directly, and issue `/fuji reload` to apply changes.\n\n\u25c9 Can I use this module in vanilla dimensions?\nYes, you can.\n"), @ColorBox(id=1752460350802L, color=ColorBox.ColorBoxTypes.TIP, value="\u25c9 The logic of `/worldborder` command.\nThe `/worldborder` command only sets the `World Border` of `minecraft:overworld`.\nBut the `minecraft:the_nether` and `minecraft:the_end` dimensions will `sync` the `world border` of `minecraft:overworld`.\n"), @ColorBox(id=1752569349615L, color=ColorBox.ColorBoxTypes.TIP, value="\u25c9 The semantics of options for `world border`.\nSee: https://minecraft.wiki/w/World_border\n")})
@TestCase(action="Issue `/tp` and `/world tp` between dimensions.", targets={"The per-dimension border should be synced on the client-side."})
public class WorldBorderInitializer
extends ModuleInitializer {
    private static final BaseConfigurationHandler<WorldBorderConfigModel> config = ObjectConfigurationHandler.ofModule("config.json", WorldBorderConfigModel.class);

    @HotPath(value="Many game logics will check the game border.")
    public static Optional<BorderDescriptor> getEffectiveBorderDescriptor(String dimensionId) {
        for (BorderDescriptor borderDescriptor : WorldBorderInitializer.config.model().borders) {
            if (!borderDescriptor.enable || !borderDescriptor.dimensionId.equals(dimensionId)) continue;
            return Optional.of(borderDescriptor);
        }
        return Optional.empty();
    }

    @Override
    protected void onReload() {
        WorldBorderInitializer.sendWorldBorderSyncPacketsToAllPlayers();
    }

    private static void sendWorldBorderSyncPacketsToAllPlayers() {
        WorldBorderInitializer.sendPerDimensionPacketToAllDimensions(dimension -> new class_5895(dimension.method_8621()));
        WorldBorderInitializer.sendPerDimensionPacketToAllDimensions(dimension -> new class_5897(dimension.method_8621()));
        WorldBorderInitializer.sendPerDimensionPacketToAllDimensions(dimension -> new class_5896(dimension.method_8621()));
        WorldBorderInitializer.sendPerDimensionPacketToAllDimensions(dimension -> new class_5899(dimension.method_8621()));
        WorldBorderInitializer.sendPerDimensionPacketToAllDimensions(dimension -> new class_5898(dimension.method_8621()));
    }

    public static void sendWorldBorderSyncPacketsToPlayer(class_3222 player, class_1937 world) {
        player.field_13987.method_14364((class_2596)new class_5895(world.method_8621()));
        player.field_13987.method_14364((class_2596)new class_5897(world.method_8621()));
        player.field_13987.method_14364((class_2596)new class_5896(world.method_8621()));
        player.field_13987.method_14364((class_2596)new class_5899(world.method_8621()));
        player.field_13987.method_14364((class_2596)new class_5898(world.method_8621()));
    }

    public static void sendPerDimensionPacketToAllDimensions(Function<class_3218, class_2596<?>> packetProvider) {
        WorldHelper.getWorlds().forEach(dimension -> {
            class_2784 callGetterMethodToUpdateEffectiveDescriptor = dimension.method_8621();
            class_5321 dimensionRegistryKey = dimension.method_27983();
            class_2596 packet = (class_2596)packetProvider.apply((class_3218)dimension);
            PlayerHelper.getPlayerManager().method_14589(packet, dimensionRegistryKey);
        });
    }
}

