/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.world.manager.service;

import io.github.sakurawald.fuji.core.annotation.Unused;
import io.github.sakurawald.fuji.core.auxiliary.LogUtil;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.RegistryHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.ServerHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.WorldHelper;
import io.github.sakurawald.fuji.core.event.annotation.EventConsumer;
import io.github.sakurawald.fuji.core.event.message.server.lifecycle.ServerStartedEvent;
import io.github.sakurawald.fuji.core.event.message.server.tick.ServerTickStartEvent;
import io.github.sakurawald.fuji.core.manager.Managers;
import io.github.sakurawald.fuji.core.manager.impl.bossbar.BossBarManager;
import io.github.sakurawald.fuji.core.structure.GlobalPos;
import io.github.sakurawald.fuji.core.structure.Pair;
import io.github.sakurawald.fuji.core.structure.TeleportTicket;
import io.github.sakurawald.fuji.module.initializer.world.manager.WorldInitializer;
import io.github.sakurawald.fuji.module.initializer.world.manager.service.structure.DimensionCreationTicket;
import io.github.sakurawald.fuji.module.initializer.world.manager.service.structure.DimensionDeletionTicket;
import io.github.sakurawald.fuji.module.initializer.world.manager.structure.RuntimeDimensionDescriptor;
import io.github.sakurawald.fuji.module.initializer.world.manager.structure.RuntimeDimensionLoader;
import io.github.sakurawald.fuji.module.initializer.world.manager.structure.RuntimeDimensionMaker;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public class WorldService {
    private static final Set<DimensionCreationTicket> dimensionCreationQueue = new ReferenceOpenHashSet();
    private static final Set<DimensionDeletionTicket> dimensionDeletionTicketQueue = new ReferenceOpenHashSet();

    @EventConsumer
    private static void processDimensionCreationAndDeletionQueue(@Unused ServerTickStartEvent event) {
        dimensionDeletionTicketQueue.removeIf(WorldService::tryConsumeDimensionDeletionTicket);
        dimensionCreationQueue.removeIf(WorldService::tryConsumeDimensionCreationTicket);
    }

    public static void submitDimensionDeletionTicket(@NotNull DimensionDeletionTicket ticket) {
        class_3218 world = ticket.world;
        WorldService.saveChunksBeforeUnloadingTheDimension(world);
        ServerHelper.executeSync(() -> dimensionDeletionTicketQueue.add(ticket));
    }

    private static void saveChunksBeforeUnloadingTheDimension(class_3218 world) {
        ServerHelper.executeSync(() -> {
            world.field_13957 = false;
            world.method_14178().method_39997();
            world.method_14178().method_12127(() -> true, false);
        });
    }

    public static void submitDimensionCreationTicket(DimensionCreationTicket ticket) {
        ServerHelper.executeSync(() -> dimensionCreationQueue.add(ticket));
    }

    private static boolean tryConsumeDimensionDeletionTicket(@NotNull DimensionDeletionTicket ticket) {
        class_3218 world = ticket.getWorld();
        if (world.method_18456().isEmpty() && !WorldService.shouldDelayShutdown(world)) {
            WorldService.consumeDimensionDeletionTicket(ticket);
            return true;
        }
        WorldService.evacuatePlayers(world);
        return false;
    }

    private static boolean shouldDelayShutdown(class_3218 world) {
        return world.method_14178().field_17254.method_39992();
    }

    private static boolean tryConsumeDimensionCreationTicket(@NotNull DimensionCreationTicket ticket) {
        if (dimensionDeletionTicketQueue.stream().anyMatch(it -> RegistryHelper.getIdAsString((class_1937)it.world).equals(ticket.descriptor.dimension))) {
            return false;
        }
        WorldService.consumeDimensionCreationTicket(ticket);
        return true;
    }

    private static void consumeDimensionCreationTicket(@NotNull DimensionCreationTicket ticket) {
        RuntimeDimensionDescriptor descriptor = ticket.descriptor;
        try {
            Pair<class_3218, class_5363> result = RuntimeDimensionMaker.makeRuntimeDimension(descriptor);
            class_3218 dimension = result.getKey();
            class_5363 dimensionOptions = result.getValue();
            RuntimeDimensionLoader.loadRuntimeDimension(dimension, dimensionOptions);
            dimension.method_18765(() -> true);
            TextHelper.sendTextByKey(ticket.source, "world.dimension.created", ticket.descriptor.dimension);
        }
        catch (Exception e) {
            LogUtil.error("Failed to make RuntimeDimension instance: dimension descriptor = {}", descriptor, e);
        }
    }

    private static void evacuatePlayers(@NotNull class_3218 dimension) {
        class_3218 safeDimension = dimension.method_8503().method_30002();
        class_2338 safeBlockPos = safeDimension.method_43126();
        ArrayList players = new ArrayList(dimension.method_18456());
        for (class_3222 player : players) {
            GlobalPos from = GlobalPos.of(player);
            GlobalPos to = new GlobalPos((class_1937)safeDimension, (double)safeBlockPos.method_10263() + 0.5, (double)safeBlockPos.method_10264() + 0.5, (double)safeBlockPos.method_10260() + 0.5, 0.0f, 0.0f);
            class_2338 topPosition = safeDimension.method_8598(class_2902.class_2903.field_13197, player.method_24515());
            to = to.withY(topPosition.method_10264());
            TeleportTicket teleportTicket = TeleportTicket.makeVipTicket(player, from, to);
            Managers.getBossBarManager();
            BossBarManager.addTicket(teleportTicket);
        }
    }

    private static void consumeDimensionDeletionTicket(@NotNull DimensionDeletionTicket ticket) {
        class_3218 world = ticket.getWorld();
        RuntimeDimensionLoader.unloadDimension(world);
        if (ticket.deleteWorldFiles) {
            WorldService.deleteDimensionFiles(world);
        }
        if (ticket.deleteRuntimeDimensionDescriptor) {
            String dimensionId = RegistryHelper.getIdAsString((class_1937)world);
            WorldService.deleteRuntimeDimensionDescriptor(dimensionId);
        }
        TextHelper.sendTextByKey(ticket.source, "world.dimension.deleted", RegistryHelper.getIdAsString((class_1937)ticket.world));
    }

    private static void deleteDimensionFiles(@NotNull class_3218 world) {
        MinecraftServer server = world.method_8503();
        class_5321 dimensionKey = world.method_27983();
        File worldDirectory = server.field_23784.method_27424(dimensionKey).toFile();
        WorldService.deleteFiles(worldDirectory);
    }

    private static void deleteFiles(@NotNull File file) {
        if (file.exists() && file.isDirectory()) {
            File[] files = file.listFiles();
            if (files == null) {
                return;
            }
            for (File child : files) {
                if (child.isDirectory()) {
                    WorldService.deleteFiles(child);
                    continue;
                }
                child.delete();
            }
        }
    }

    public static boolean existsDimension(class_2960 dimensionId) {
        boolean dimensionExistedInRuntime = WorldHelper.getWorlds().stream().anyMatch(it -> RegistryHelper.getIdAsString((class_1937)it).equals(dimensionId.toString()));
        boolean dimensionExistedInConfig = WorldService.getRuntimeDimensionDescriptor(dimensionId.toString()).isPresent();
        return dimensionExistedInRuntime || dimensionExistedInConfig;
    }

    public static void deleteRuntimeDimensionDescriptor(String dimensionId) {
        Optional<RuntimeDimensionDescriptor> first = WorldInitializer.world.model().dimension_list.stream().filter(o -> o.getDimension().equals(dimensionId)).findFirst();
        first.ifPresent(dimensionNode -> {
            WorldInitializer.world.model().dimension_list.remove(dimensionNode);
            WorldInitializer.world.writeStorage();
        });
    }

    public static void saveRuntimeDimensionDescriptors() {
        WorldInitializer.config.writeStorage();
    }

    public static Optional<RuntimeDimensionDescriptor> getRuntimeDimensionDescriptor(String dimensionId) {
        return WorldInitializer.world.model().dimension_list.stream().filter(it -> it.dimension.equalsIgnoreCase(dimensionId)).findFirst();
    }

    public static List<RuntimeDimensionDescriptor> getRuntimeDimensionDescriptors() {
        return WorldInitializer.world.model().dimension_list;
    }

    @EventConsumer
    private static void loadRuntimeDimensions(@Unused ServerStartedEvent event) {
        WorldInitializer.world.model().dimension_list.stream().filter(RuntimeDimensionDescriptor::isAuto_load_on_server_startup).forEach(it -> {
            try {
                DimensionCreationTicket ticket = new DimensionCreationTicket(ServerHelper.getServer().method_3739(), (RuntimeDimensionDescriptor)it);
                WorldService.submitDimensionCreationTicket(ticket);
                LogUtil.info("Load dimension {} into the server.", it.getDimension());
            }
            catch (Exception e) {
                LogUtil.error("Failed to load dimension `{}`", it, e);
            }
        });
    }
}

