/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.mixin.command_permission;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.tree.CommandNode;
import io.github.sakurawald.fuji.core.auxiliary.LogUtil;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.CommandHelper;
import io.github.sakurawald.fuji.module.initializer.command_permission.service.CommandPermissionService;
import io.github.sakurawald.fuji.module.initializer.command_permission.structure.WrappedPredicate;
import java.util.function.Predicate;
import net.minecraft.class_2168;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={CommandNode.class}, remap=false)
public class CommandNodeMixin {
    @Mutable
    @Shadow
    @Final
    private Predicate<Object> requirement;

    @ModifyReturnValue(method={"getRequirement"}, at={@At(value="RETURN")})
    private Predicate<Object> wrapRequirementPredicateForThisCommandNode(Predicate<Object> original) {
        @Nullable CommandDispatcher<class_2168> dispatcher = CommandHelper.getCommandDispatcher();
        if (dispatcher == null) {
            LogUtil.debug("The CommandNode#getRequirement is triggered too early, fuji will just ignore this call.", new Object[0]);
            return original;
        }
        if (!(original instanceof WrappedPredicate)) {
            CommandNode node = (CommandNode)this;
            this.requirement = CommandPermissionService.makeWrappedPredicate((CommandNode<class_2168>)node, original);
            return this.requirement;
        }
        return original;
    }
}

